/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.AbstractPartition;
import io.debezium.util.Collect;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class SqlServerPartition
extends AbstractPartition
implements Partition {
    private static final String SERVER_PARTITION_KEY = "server";
    private static final String DATABASE_PARTITION_KEY = "database";
    private final String serverName;
    private final Map<String, String> sourcePartition;
    private final List<Map<String, String>> supportedFormats;
    private final int hashCode;

    public SqlServerPartition(String serverName, String databaseName) {
        this(serverName, databaseName, true);
    }

    public SqlServerPartition(String serverName, String databaseName, boolean multiPartitionMode) {
        super(databaseName);
        this.serverName = serverName;
        this.sourcePartition = Collect.hashMapOf((Object)SERVER_PARTITION_KEY, (Object)serverName, (Object)DATABASE_PARTITION_KEY, (Object)databaseName);
        this.supportedFormats = multiPartitionMode ? Collections.singletonList(this.sourcePartition) : Arrays.asList(this.sourcePartition, Collect.hashMapOf((Object)SERVER_PARTITION_KEY, (Object)serverName));
        this.hashCode = Objects.hash(serverName, databaseName);
    }

    public Map<String, String> getSourcePartition() {
        return this.sourcePartition;
    }

    public List<Map<String, String>> getSupportedFormats() {
        return this.supportedFormats;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SqlServerPartition other = (SqlServerPartition)((Object)obj);
        return Objects.equals(this.serverName, other.serverName) && Objects.equals(this.databaseName, other.databaseName);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "SqlServerPartition [sourcePartition=" + String.valueOf(this.getSourcePartition()) + "]";
    }

    static class Provider
    implements Partition.Provider<SqlServerPartition> {
        private final SqlServerConnectorConfig connectorConfig;

        Provider(SqlServerConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        public Set<SqlServerPartition> getPartitions() {
            String serverName = this.connectorConfig.getLogicalName();
            boolean multiPartitionMode = this.connectorConfig.getDatabaseNames().size() > 1;
            return this.connectorConfig.getDatabaseNames().stream().map(databaseName -> new SqlServerPartition(serverName, (String)databaseName, multiPartitionMode)).collect(Collectors.toSet());
        }
    }
}

