/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver.metrics;

import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.sqlserver.metrics.AbstractSqlServerPartitionMetrics;
import io.debezium.connector.sqlserver.metrics.SqlServerSnapshotPartitionMetricsMXBean;
import io.debezium.pipeline.meters.SnapshotMeter;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.relational.TableId;
import io.debezium.spi.schema.DataCollectionId;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

class SqlServerSnapshotPartitionMetrics
extends AbstractSqlServerPartitionMetrics
implements SqlServerSnapshotPartitionMetricsMXBean {
    private final SnapshotMeter snapshotMeter;

    SqlServerSnapshotPartitionMetrics(CdcSourceTaskContext taskContext, Map<String, String> tags, EventMetadataProvider metadataProvider) {
        super(taskContext, tags, metadataProvider);
        this.snapshotMeter = new SnapshotMeter(taskContext.getClock());
    }

    public int getTotalTableCount() {
        return this.snapshotMeter.getTotalTableCount();
    }

    public int getRemainingTableCount() {
        return this.snapshotMeter.getRemainingTableCount();
    }

    public boolean getSnapshotRunning() {
        return this.snapshotMeter.getSnapshotRunning();
    }

    public boolean getSnapshotPaused() {
        return this.snapshotMeter.getSnapshotPaused();
    }

    public boolean getSnapshotCompleted() {
        return this.snapshotMeter.getSnapshotCompleted();
    }

    public boolean getSnapshotAborted() {
        return this.snapshotMeter.getSnapshotAborted();
    }

    public long getSnapshotDurationInSeconds() {
        return this.snapshotMeter.getSnapshotDurationInSeconds();
    }

    public long getSnapshotPausedDurationInSeconds() {
        return this.snapshotMeter.getSnapshotPausedDurationInSeconds();
    }

    public String[] getCapturedTables() {
        return this.snapshotMeter.getCapturedTables();
    }

    void monitoredDataCollectionsDetermined(Iterable<? extends DataCollectionId> dataCollectionIds) {
        this.snapshotMeter.monitoredDataCollectionsDetermined(dataCollectionIds);
    }

    void dataCollectionSnapshotCompleted(DataCollectionId dataCollectionId, long numRows) {
        this.snapshotMeter.dataCollectionSnapshotCompleted(dataCollectionId, numRows);
    }

    void snapshotStarted() {
        this.snapshotMeter.snapshotStarted();
    }

    void snapshotPaused() {
        this.snapshotMeter.snapshotPaused();
    }

    void snapshotResumed() {
        this.snapshotMeter.snapshotResumed();
    }

    void snapshotCompleted() {
        this.snapshotMeter.snapshotCompleted();
    }

    void snapshotAborted() {
        this.snapshotMeter.snapshotAborted();
    }

    void rowsScanned(TableId tableId, long numRows) {
        this.snapshotMeter.rowsScanned(tableId, numRows);
    }

    public ConcurrentMap<String, Long> getRowsScanned() {
        return this.snapshotMeter.getRowsScanned();
    }

    void currentChunk(String chunkId, Object[] chunkFrom, Object[] chunkTo) {
        this.snapshotMeter.currentChunk(chunkId, chunkFrom, chunkTo);
    }

    void currentChunk(String chunkId, Object[] chunkFrom, Object[] chunkTo, Object[] tableTo) {
        this.snapshotMeter.currentChunk(chunkId, chunkFrom, chunkTo, tableTo);
    }

    public String getChunkId() {
        return this.snapshotMeter.getChunkId();
    }

    public String getChunkFrom() {
        return this.snapshotMeter.getChunkFrom();
    }

    public String getChunkTo() {
        return this.snapshotMeter.getChunkTo();
    }

    public String getTableFrom() {
        return this.snapshotMeter.getTableFrom();
    }

    public String getTableTo() {
        return this.snapshotMeter.getTableTo();
    }

    @Override
    public void reset() {
        this.snapshotMeter.reset();
    }
}

