/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.SqlServerDatabaseSchema;
import io.debezium.connector.sqlserver.SqlServerOffsetContext;
import io.debezium.connector.sqlserver.SqlServerPartition;
import io.debezium.connector.sqlserver.SqlServerSnapshotChangeEventSource;
import io.debezium.connector.sqlserver.SqlServerStreamingChangeEventSource;
import io.debezium.jdbc.MainConnectionProvidingConnectionFactory;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotChangeEventSource;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.source.spi.DataChangeEventListener;
import io.debezium.pipeline.source.spi.SnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.schema.DatabaseSchema;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Clock;
import io.debezium.util.Strings;
import java.util.Optional;

public class SqlServerChangeEventSourceFactory
implements ChangeEventSourceFactory<SqlServerPartition, SqlServerOffsetContext> {
    private final SqlServerConnectorConfig configuration;
    private final MainConnectionProvidingConnectionFactory<SqlServerConnection> connectionFactory;
    private final SqlServerConnection metadataConnection;
    private final ErrorHandler errorHandler;
    private final EventDispatcher<SqlServerPartition, TableId> dispatcher;
    private final Clock clock;
    private final SqlServerDatabaseSchema schema;
    private final NotificationService<SqlServerPartition, SqlServerOffsetContext> notificationService;
    private final SnapshotterService snapshotterService;

    public SqlServerChangeEventSourceFactory(SqlServerConnectorConfig configuration, MainConnectionProvidingConnectionFactory<SqlServerConnection> connectionFactory, SqlServerConnection metadataConnection, ErrorHandler errorHandler, EventDispatcher<SqlServerPartition, TableId> dispatcher, Clock clock, SqlServerDatabaseSchema schema, NotificationService<SqlServerPartition, SqlServerOffsetContext> notificationService, SnapshotterService snapshotterService) {
        this.configuration = configuration;
        this.connectionFactory = connectionFactory;
        this.metadataConnection = metadataConnection;
        this.errorHandler = errorHandler;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.schema = schema;
        this.notificationService = notificationService;
        this.snapshotterService = snapshotterService;
    }

    public SnapshotChangeEventSource<SqlServerPartition, SqlServerOffsetContext> getSnapshotChangeEventSource(SnapshotProgressListener<SqlServerPartition> snapshotProgressListener, NotificationService<SqlServerPartition, SqlServerOffsetContext> notificationService) {
        return new SqlServerSnapshotChangeEventSource(this.configuration, this.connectionFactory, this.schema, this.dispatcher, this.clock, snapshotProgressListener, notificationService, this.snapshotterService);
    }

    public StreamingChangeEventSource<SqlServerPartition, SqlServerOffsetContext> getStreamingChangeEventSource() {
        return new SqlServerStreamingChangeEventSource(this.configuration, (SqlServerConnection)this.connectionFactory.mainConnection(), this.metadataConnection, this.dispatcher, this.errorHandler, this.clock, this.schema, this.notificationService, this.snapshotterService);
    }

    public Optional<IncrementalSnapshotChangeEventSource<SqlServerPartition, ? extends DataCollectionId>> getIncrementalSnapshotChangeEventSource(SqlServerOffsetContext offsetContext, SnapshotProgressListener<SqlServerPartition> snapshotProgressListener, DataChangeEventListener<SqlServerPartition> dataChangeEventListener, NotificationService<SqlServerPartition, SqlServerOffsetContext> notificationService) {
        if (Strings.isNullOrEmpty((String)this.configuration.getSignalingDataCollectionId())) {
            return Optional.empty();
        }
        SignalBasedIncrementalSnapshotChangeEventSource incrementalSnapshotChangeEventSource = new SignalBasedIncrementalSnapshotChangeEventSource((RelationalDatabaseConnectorConfig)this.configuration, this.connectionFactory.mainConnection(), this.dispatcher, (DatabaseSchema)this.schema, this.clock, snapshotProgressListener, dataChangeEventListener, notificationService);
        return Optional.of(incrementalSnapshotChangeEventSource);
    }
}

