/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.connector.sqlserver.SqlServerChangeTable;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.SqlServerDatabaseSchema;
import io.debezium.connector.sqlserver.SqlServerOffsetContext;
import io.debezium.connector.sqlserver.SqlServerPartition;
import io.debezium.connector.sqlserver.TxLogPosition;
import io.debezium.jdbc.MainConnectionProvidingConnectionFactory;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.source.AbstractSnapshotChangeEventSource;
import io.debezium.pipeline.source.SnapshottingTask;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.ChangeTable;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.relational.RelationalSnapshotChangeEventSource;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Clock;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerSnapshotChangeEventSource
extends RelationalSnapshotChangeEventSource<SqlServerPartition, SqlServerOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlServerSnapshotChangeEventSource.class);
    private static final int TRANSACTION_SNAPSHOT = 4096;
    private final SqlServerConnectorConfig connectorConfig;
    private final SqlServerConnection jdbcConnection;
    private final SqlServerDatabaseSchema sqlServerDatabaseSchema;
    private final Map<SqlServerPartition, Map<TableId, SqlServerChangeTable>> changeTablesByPartition = new HashMap<SqlServerPartition, Map<TableId, SqlServerChangeTable>>();

    public SqlServerSnapshotChangeEventSource(SqlServerConnectorConfig connectorConfig, MainConnectionProvidingConnectionFactory<SqlServerConnection> connectionFactory, SqlServerDatabaseSchema schema, EventDispatcher<SqlServerPartition, TableId> dispatcher, Clock clock, SnapshotProgressListener<SqlServerPartition> snapshotProgressListener, NotificationService<SqlServerPartition, SqlServerOffsetContext> notificationService) {
        super((RelationalDatabaseConnectorConfig)connectorConfig, connectionFactory, (RelationalDatabaseSchema)schema, dispatcher, clock, snapshotProgressListener, notificationService);
        this.connectorConfig = connectorConfig;
        this.jdbcConnection = (SqlServerConnection)connectionFactory.mainConnection();
        this.sqlServerDatabaseSchema = schema;
    }

    public SnapshottingTask getSnapshottingTask(SqlServerPartition partition, SqlServerOffsetContext previousOffset) {
        boolean snapshotSchema = true;
        boolean snapshotData = true;
        List dataCollectionsToBeSnapshotted = this.connectorConfig.getDataCollectionsToBeSnapshotted();
        Map<String, String> snapshotSelectOverridesByTable = this.connectorConfig.getSnapshotSelectOverridesByTable().entrySet().stream().collect(Collectors.toMap(e -> ((DataCollectionId)e.getKey()).identifier(), Map.Entry::getValue));
        if (previousOffset != null && !previousOffset.isSnapshotRunning()) {
            LOGGER.info("A previous offset indicating a completed snapshot has been found. Neither schema nor data will be snapshotted.");
            snapshotSchema = false;
            snapshotData = false;
        } else {
            LOGGER.info("No previous offset has been found");
            if (this.connectorConfig.getSnapshotMode().includeData()) {
                LOGGER.info("According to the connector configuration both schema and data will be snapshotted");
            } else {
                LOGGER.info("According to the connector configuration only schema will be snapshotted");
            }
            snapshotData = this.connectorConfig.getSnapshotMode().includeData();
        }
        return new SnapshottingTask(snapshotSchema, snapshotData, dataCollectionsToBeSnapshotted, snapshotSelectOverridesByTable, false);
    }

    protected AbstractSnapshotChangeEventSource.SnapshotContext<SqlServerPartition, SqlServerOffsetContext> prepare(SqlServerPartition partition, boolean onDemand) {
        return new SqlServerSnapshotContext(partition, onDemand);
    }

    protected void connectionCreated(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<SqlServerPartition, SqlServerOffsetContext> snapshotContext) throws Exception {
        ((SqlServerSnapshotContext)snapshotContext).isolationLevelBeforeStart = this.jdbcConnection.connection().getTransactionIsolation();
        if (this.connectorConfig.getSnapshotIsolationMode() == SqlServerConnectorConfig.SnapshotIsolationMode.SNAPSHOT) {
            this.jdbcConnection.connection().rollback();
            this.jdbcConnection.connection().setTransactionIsolation(4096);
        }
    }

    protected Set<TableId> getAllTableIds(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<SqlServerPartition, SqlServerOffsetContext> ctx) throws Exception {
        return this.jdbcConnection.readTableNames(ctx.catalogName, null, null, new String[]{"TABLE"});
    }

    protected void lockTablesForSchemaSnapshot(ChangeEventSource.ChangeEventSourceContext sourceContext, RelationalSnapshotChangeEventSource.RelationalSnapshotContext<SqlServerPartition, SqlServerOffsetContext> snapshotContext) throws SQLException, InterruptedException {
        if (this.connectorConfig.getSnapshotIsolationMode() == SqlServerConnectorConfig.SnapshotIsolationMode.READ_UNCOMMITTED) {
            this.jdbcConnection.connection().setTransactionIsolation(1);
            LOGGER.info("Schema locking was disabled in connector configuration");
        } else if (this.connectorConfig.getSnapshotIsolationMode() == SqlServerConnectorConfig.SnapshotIsolationMode.READ_COMMITTED) {
            this.jdbcConnection.connection().setTransactionIsolation(2);
            LOGGER.info("Schema locking was disabled in connector configuration");
        } else if (this.connectorConfig.getSnapshotIsolationMode() == SqlServerConnectorConfig.SnapshotIsolationMode.SNAPSHOT) {
            LOGGER.info("Schema locking was disabled in connector configuration");
        } else if (this.connectorConfig.getSnapshotIsolationMode() == SqlServerConnectorConfig.SnapshotIsolationMode.EXCLUSIVE || this.connectorConfig.getSnapshotIsolationMode() == SqlServerConnectorConfig.SnapshotIsolationMode.REPEATABLE_READ) {
            LOGGER.info("Setting locking timeout to {} s", (Object)this.connectorConfig.snapshotLockTimeout().getSeconds());
            this.jdbcConnection.execute(new String[]{"SET LOCK_TIMEOUT " + this.connectorConfig.snapshotLockTimeout().toMillis()});
            this.jdbcConnection.connection().setTransactionIsolation(4);
            ((SqlServerSnapshotContext)snapshotContext).preSchemaSnapshotSavepoint = this.jdbcConnection.connection().setSavepoint("dbz_schema_snapshot");
            LOGGER.info("Executing schema locking");
            try (Statement statement = this.jdbcConnection.connection().createStatement(1003, 1007);){
                for (TableId tableId : snapshotContext.capturedTables) {
                    if (!sourceContext.isRunning()) {
                        throw new InterruptedException("Interrupted while locking table " + tableId);
                    }
                    LOGGER.info("Locking table {}", (Object)tableId);
                    String query = String.format("SELECT TOP(0) * FROM [%s].[%s].[%s] WITH (TABLOCKX)", tableId.catalog(), tableId.schema(), tableId.table());
                    statement.executeQuery(query).close();
                }
            }
        } else {
            throw new IllegalStateException("Unknown locking mode specified.");
        }
    }

    protected void releaseSchemaSnapshotLocks(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<SqlServerPartition, SqlServerOffsetContext> snapshotContext) throws SQLException {
        if (this.connectorConfig.getSnapshotIsolationMode() == SqlServerConnectorConfig.SnapshotIsolationMode.REPEATABLE_READ) {
            this.jdbcConnection.connection().rollback(((SqlServerSnapshotContext)snapshotContext).preSchemaSnapshotSavepoint);
            LOGGER.info("Schema locks released.");
        }
    }

    protected void determineSnapshotOffset(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<SqlServerPartition, SqlServerOffsetContext> ctx, SqlServerOffsetContext previousOffset) throws Exception {
        ctx.offset = new SqlServerOffsetContext(this.connectorConfig, TxLogPosition.valueOf(this.jdbcConnection.getMaxLsn(((SqlServerPartition)ctx.partition).getDatabaseName())), false, false);
    }

    protected void readTableStructure(ChangeEventSource.ChangeEventSourceContext sourceContext, RelationalSnapshotChangeEventSource.RelationalSnapshotContext<SqlServerPartition, SqlServerOffsetContext> snapshotContext, SqlServerOffsetContext offsetContext, SnapshottingTask snapshottingTask) throws SQLException, InterruptedException {
        Set schemas = snapshotContext.capturedTables.stream().map(TableId::schema).collect(Collectors.toSet());
        Map<TableId, SqlServerChangeTable> changeTables = this.jdbcConnection.getChangeTables(((SqlServerPartition)snapshotContext.partition).getDatabaseName()).stream().collect(Collectors.toMap(ChangeTable::getSourceTableId, changeTable -> changeTable, (changeTable1, changeTable2) -> changeTable1.getStartLsn().compareTo(changeTable2.getStartLsn()) > 0 ? changeTable1 : changeTable2));
        for (String schema : schemas) {
            if (!sourceContext.isRunning()) {
                throw new InterruptedException("Interrupted while reading structure of schema " + schema);
            }
            LOGGER.info("Reading structure of schema '{}'", (Object)snapshotContext.catalogName);
            Tables.TableFilter tableFilter = snapshottingTask.isOnDemand() ? Tables.TableFilter.fromPredicate(snapshotContext.capturedTables::contains) : this.connectorConfig.getTableFilters().dataCollectionFilter();
            this.jdbcConnection.readSchema(snapshotContext.tables, snapshotContext.catalogName, schema, tableFilter, null, false);
            changeTables.forEach((tableId, sqlServerChangeTable) -> {
                Table sourceTable = snapshotContext.tables.forTable(tableId);
                if (sourceTable != null) {
                    List cdcEnabledSourceColumns = sourceTable.filterColumns(column -> sqlServerChangeTable.getCapturedColumns().contains(column.name()));
                    List cdcEnabledPkColumns = sourceTable.primaryKeyColumnNames().stream().filter(column -> sqlServerChangeTable.getCapturedColumns().contains(column)).collect(Collectors.toList());
                    snapshotContext.tables.overwriteTable(sourceTable.id(), cdcEnabledSourceColumns, cdcEnabledPkColumns, sourceTable.defaultCharsetName(), sourceTable.attributes());
                }
            });
        }
        this.changeTablesByPartition.put((SqlServerPartition)snapshotContext.partition, changeTables);
    }

    protected SchemaChangeEvent getCreateTableEvent(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<SqlServerPartition, SqlServerOffsetContext> snapshotContext, Table table) throws SQLException {
        return SchemaChangeEvent.ofSnapshotCreate((Partition)snapshotContext.partition, (OffsetContext)snapshotContext.offset, (String)snapshotContext.catalogName, (Table)table);
    }

    protected void completed(AbstractSnapshotChangeEventSource.SnapshotContext<SqlServerPartition, SqlServerOffsetContext> snapshotContext) {
        this.close(snapshotContext);
    }

    protected void aborted(AbstractSnapshotChangeEventSource.SnapshotContext<SqlServerPartition, SqlServerOffsetContext> snapshotContext) {
        this.close(snapshotContext);
    }

    private void close(AbstractSnapshotChangeEventSource.SnapshotContext<SqlServerPartition, SqlServerOffsetContext> snapshotContext) {
        try {
            this.jdbcConnection.connection().setTransactionIsolation(((SqlServerSnapshotContext)snapshotContext).isolationLevelBeforeStart);
            LOGGER.info("Removing locking timeout");
            this.jdbcConnection.execute(new String[]{"SET LOCK_TIMEOUT -1"});
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to set transaction isolation level.", e);
        }
    }

    protected Optional<String> getSnapshotSelect(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<SqlServerPartition, SqlServerOffsetContext> snapshotContext, TableId tableId, List<String> columns) {
        String snapshotSelectColumns = columns.stream().collect(Collectors.joining(", "));
        return Optional.of(String.format("SELECT %s FROM [%s].[%s].[%s]", snapshotSelectColumns, tableId.catalog(), tableId.schema(), tableId.table()));
    }

    protected String enhanceOverriddenSelect(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<SqlServerPartition, SqlServerOffsetContext> snapshotContext, String overriddenSelect, TableId tableId) {
        String snapshotSelectColumns = this.getPreparedColumnNames((SqlServerPartition)snapshotContext.partition, this.sqlServerDatabaseSchema.tableFor(tableId)).stream().collect(Collectors.joining(", "));
        return overriddenSelect.replaceAll(SELECT_ALL_PATTERN.pattern(), snapshotSelectColumns);
    }

    protected boolean additionalColumnFilter(SqlServerPartition partition, TableId tableId, String columnName) {
        return this.filterChangeTableColumns(partition, tableId, columnName);
    }

    private boolean filterChangeTableColumns(SqlServerPartition partition, TableId tableId, String columnName) {
        SqlServerChangeTable changeTable = this.changeTablesByPartition.get((Object)partition).get(tableId);
        if (changeTable != null) {
            return changeTable.getCapturedColumns().contains(columnName);
        }
        return true;
    }

    protected SqlServerOffsetContext copyOffset(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<SqlServerPartition, SqlServerOffsetContext> snapshotContext) {
        return new SqlServerOffsetContext.Loader(this.connectorConfig).load(((SqlServerOffsetContext)snapshotContext.offset).getOffset());
    }

    private static class SqlServerSnapshotContext
    extends RelationalSnapshotChangeEventSource.RelationalSnapshotContext<SqlServerPartition, SqlServerOffsetContext> {
        private int isolationLevelBeforeStart;
        private Savepoint preSchemaSnapshotSavepoint;

        SqlServerSnapshotContext(SqlServerPartition partition, boolean onDemand) {
            super((Partition)partition, partition.getDatabaseName(), onDemand);
        }
    }
}

