/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.connector.sqlserver.Lsn;
import io.debezium.relational.ChangeTable;
import io.debezium.relational.TableId;

public class SqlServerChangeTable
extends ChangeTable {
    private static final String CDC_SCHEMA = "cdc";
    private final Lsn startLsn;
    private Lsn stopLsn;

    public SqlServerChangeTable(TableId sourceTableId, String captureInstance, int changeTableObjectId, Lsn startLsn, Lsn stopLsn) {
        super(captureInstance, sourceTableId, SqlServerChangeTable.resolveChangeTableId(sourceTableId, captureInstance), changeTableObjectId);
        this.startLsn = startLsn;
        this.stopLsn = stopLsn;
    }

    public SqlServerChangeTable(String captureInstance, int changeTableObjectId, Lsn startLsn, Lsn stopLsn) {
        this(null, captureInstance, changeTableObjectId, startLsn, stopLsn);
    }

    public Lsn getStartLsn() {
        return this.startLsn;
    }

    public Lsn getStopLsn() {
        return this.stopLsn;
    }

    public void setStopLsn(Lsn stopLsn) {
        this.stopLsn = stopLsn;
    }

    public String toString() {
        return "Capture instance \"" + this.getCaptureInstance() + "\" [sourceTableId=" + this.getSourceTableId() + ", changeTableId=" + this.getChangeTableId() + ", startLsn=" + this.startLsn + ", changeTableObjectId=" + this.getChangeTableObjectId() + ", stopLsn=" + this.stopLsn + "]";
    }

    private static TableId resolveChangeTableId(TableId sourceTableId, String captureInstance) {
        return sourceTableId != null ? new TableId(sourceTableId.catalog(), CDC_SCHEMA, captureInstance + "_CT") : null;
    }
}

