/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.data.Envelope;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.RelationalChangeRecordEmitter;
import io.debezium.relational.Table;
import io.debezium.util.Clock;

public class SqlServerChangeRecordEmitter
extends RelationalChangeRecordEmitter {
    public static final int OP_DELETE = 1;
    public static final int OP_INSERT = 2;
    public static final int OP_UPDATE_BEFORE = 3;
    public static final int OP_UPDATE_AFTER = 4;
    private final int operation;
    private final Object[] data;
    private final Object[] dataNext;

    public SqlServerChangeRecordEmitter(OffsetContext offset, int operation, Object[] data, Object[] dataNext, Table table, Clock clock) {
        super(offset, clock);
        this.operation = operation;
        this.data = data;
        this.dataNext = dataNext;
    }

    protected Envelope.Operation getOperation() {
        if (this.operation == 1) {
            return Envelope.Operation.DELETE;
        }
        if (this.operation == 2) {
            return Envelope.Operation.CREATE;
        }
        if (this.operation == 3) {
            return Envelope.Operation.UPDATE;
        }
        throw new IllegalArgumentException("Received event of unexpected command type: " + this.operation);
    }

    protected Object[] getOldColumnValues() {
        switch (this.getOperation()) {
            case CREATE: 
            case READ: {
                return null;
            }
        }
        return this.data;
    }

    protected Object[] getNewColumnValues() {
        switch (this.getOperation()) {
            case CREATE: 
            case READ: {
                return this.data;
            }
            case UPDATE: {
                return this.dataNext;
            }
        }
        return null;
    }
}

