/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db.model.event;

import com.google.cloud.Timestamp;
import io.debezium.connector.spanner.db.model.StreamEventMetadata;
import io.debezium.connector.spanner.db.model.event.ChangeStreamEvent;
import java.util.List;
import java.util.Objects;

public class PartitionStartEvent
implements ChangeStreamEvent {
    private final Timestamp startTimestamp;
    private final String recordSequence;
    private final List<String> partitionTokens;
    private final boolean isFromInitialPartition;
    private final StreamEventMetadata metadata;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionStartEvent that = (PartitionStartEvent)o;
        if (!Objects.equals(this.startTimestamp, that.startTimestamp)) {
            return false;
        }
        if (!Objects.equals(this.recordSequence, that.recordSequence)) {
            return false;
        }
        if (!Objects.equals(this.partitionTokens, that.partitionTokens)) {
            return false;
        }
        if (!Objects.equals(this.isFromInitialPartition, that.isFromInitialPartition)) {
            return false;
        }
        return Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        int result = this.startTimestamp != null ? this.startTimestamp.hashCode() : 0;
        result = 31 * result + (this.recordSequence != null ? this.recordSequence.hashCode() : 0);
        result = 31 * result + (this.partitionTokens != null ? this.partitionTokens.hashCode() : 0);
        result = 31 * result + (this.isFromInitialPartition ? 1 : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    public PartitionStartEvent(Timestamp startTimestamp, String recordSequence, List<String> partitionTokens, boolean isFromInitialPartition, StreamEventMetadata metadata) {
        this.startTimestamp = startTimestamp;
        this.recordSequence = recordSequence;
        this.partitionTokens = partitionTokens;
        this.isFromInitialPartition = isFromInitialPartition;
        this.metadata = metadata;
    }

    @Override
    public Timestamp getRecordTimestamp() {
        return this.getStartTimestamp();
    }

    public Timestamp getStartTimestamp() {
        return this.startTimestamp;
    }

    public String getRecordSequence() {
        return this.recordSequence;
    }

    public List<String> getPartitionTokens() {
        return this.partitionTokens;
    }

    public boolean isFromInitialPartition() {
        return this.isFromInitialPartition;
    }

    @Override
    public StreamEventMetadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "PartitionStartEvent{startTimestamp=" + String.valueOf(this.startTimestamp) + ", recordSequence='" + this.recordSequence + "', partitionToken=" + String.valueOf(this.partitionTokens) + ", isFromInitialPartition=" + this.isFromInitialPartition + ", metadata=" + String.valueOf(this.metadata) + "}";
    }
}

