/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db.dao;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import io.debezium.connector.spanner.db.dao.ChangeStreamResultSet;
import io.debezium.connector.spanner.db.model.InitialPartition;

public class ChangeStreamDao {
    private final String changeStreamName;
    private final DatabaseClient databaseClient;
    private final Options.RpcPriority rpcPriority;
    private final String jobName;
    private final boolean isMutableKeyRange;

    public ChangeStreamDao(String changeStreamName, boolean isMutableKeyRange, DatabaseClient databaseClient, Options.RpcPriority rpcPriority, String jobName) {
        this.changeStreamName = changeStreamName;
        this.isMutableKeyRange = isMutableKeyRange;
        this.databaseClient = databaseClient;
        this.rpcPriority = rpcPriority;
        this.jobName = jobName;
    }

    public ChangeStreamResultSet streamQuery(String partitionToken, Timestamp startTimestamp, Timestamp endTimestamp, long heartbeatMillis) {
        Statement statement;
        String partitionTokenOrNull;
        String string = partitionTokenOrNull = InitialPartition.isInitialPartition(partitionToken) ? null : partitionToken;
        if (this.isPostgres()) {
            String query = this.isMutableKeyRange ? "SELECT * FROM \"spanner\".\"read_proto_bytes_" + this.changeStreamName + "\"($1, $2, $3, $4, null)" : "SELECT * FROM \"spanner\".\"read_json_" + this.changeStreamName + "\"($1, $2, $3, $4, null)";
            statement = ((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)query).bind("p1").to(startTimestamp)).bind("p2").to(endTimestamp)).bind("p3").to(partitionTokenOrNull)).bind("p4").to(heartbeatMillis)).build();
        } else {
            String query = "SELECT * FROM READ_" + this.changeStreamName + "(   start_timestamp => @startTimestamp,   end_timestamp => @endTimestamp,   partition_token => @partitionToken,   read_options => null,   heartbeat_milliseconds => @heartbeatMillis)";
            statement = ((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)query).bind("startTimestamp").to(startTimestamp)).bind("endTimestamp").to(endTimestamp)).bind("partitionToken").to(partitionTokenOrNull)).bind("heartbeatMillis").to(heartbeatMillis)).build();
        }
        ResultSet resultSet = this.databaseClient.singleUse().executeQuery(statement, new Options.QueryOption[]{Options.priority((Options.RpcPriority)this.rpcPriority), Options.tag((String)("kafka-spanner-connector-job=" + this.jobName))});
        return new ChangeStreamResultSet(resultSet);
    }

    public boolean isPostgres() {
        return this.databaseClient.getDialect() == Dialect.POSTGRESQL;
    }
}

