/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task.scaler;

import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.connector.spanner.kafka.internal.SyncEventConsumerFactory;
import io.debezium.connector.spanner.kafka.internal.TaskSyncEventListener;
import io.debezium.connector.spanner.task.scaler.FixedTaskScalerMonitorImpl;
import io.debezium.connector.spanner.task.scaler.TaskScaler;
import io.debezium.connector.spanner.task.scaler.TaskScalerMonitor;
import io.debezium.connector.spanner.task.scaler.TaskScalerMonitorImpl;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.kafka.connect.connector.ConnectorContext;

public class TaskScalerMonitorFactory {
    private final SpannerConnectorConfig connectorConfig;
    private final ConnectorContext connectorContext;
    private final Consumer<RuntimeException> errorHandler;

    public TaskScalerMonitorFactory(SpannerConnectorConfig connectorConfig, ConnectorContext connectorContext, Consumer<RuntimeException> errorHandler) {
        this.connectorConfig = connectorConfig;
        this.connectorContext = connectorContext;
        this.errorHandler = errorHandler;
    }

    public TaskScalerMonitor createMonitor() {
        if (this.connectorConfig.isScalerMonitorEnabled()) {
            return this.createScalingTaskMonitor();
        }
        return this.createFixedTaskMonitor();
    }

    private TaskScalerMonitor createScalingTaskMonitor() {
        String consumerGroup = "scaler-group-" + String.valueOf(UUID.randomUUID());
        SyncEventConsumerFactory<String, byte[]> syncEventConsumerFactory = new SyncEventConsumerFactory<String, byte[]>(this.connectorConfig, true);
        TaskSyncEventListener syncEventListener = new TaskSyncEventListener(consumerGroup, this.connectorConfig.taskSyncTopic(), syncEventConsumerFactory, false, this.errorHandler);
        return new TaskScalerMonitorImpl(syncEventListener, new TaskScaler(this.connectorConfig, this.connectorContext), this.connectorConfig.getMinTasks());
    }

    private TaskScalerMonitor createFixedTaskMonitor() {
        return new FixedTaskScalerMonitorImpl(this.connectorConfig.getMaxTasks());
    }
}

