/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task;

import io.debezium.connector.spanner.PartitionManager;
import io.debezium.connector.spanner.db.model.Partition;
import io.debezium.connector.spanner.kafka.internal.model.PartitionStateEnum;
import io.debezium.connector.spanner.task.state.NewPartitionsEvent;
import io.debezium.connector.spanner.task.state.PartitionStatusUpdateEvent;
import io.debezium.connector.spanner.task.state.TaskStateChangeEvent;
import io.debezium.function.BlockingConsumer;
import java.util.List;

public class SynchronizedPartitionManager
implements PartitionManager {
    private final BlockingConsumer<TaskStateChangeEvent> syncEventPublisher;

    public SynchronizedPartitionManager(BlockingConsumer<TaskStateChangeEvent> syncEventPublisher) {
        this.syncEventPublisher = syncEventPublisher;
    }

    @Override
    public void newChildPartitions(List<Partition> partitions) throws InterruptedException {
        this.syncEventPublisher.accept((Object)new NewPartitionsEvent(partitions));
    }

    @Override
    public void updateToFinished(String token) throws InterruptedException {
        this.syncEventPublisher.accept((Object)new PartitionStatusUpdateEvent(token, PartitionStateEnum.FINISHED));
    }

    @Override
    public void updateToRunning(String token) throws InterruptedException {
        this.syncEventPublisher.accept((Object)new PartitionStatusUpdateEvent(token, PartitionStateEnum.RUNNING));
    }

    @Override
    public void updateToReadyForStreaming(String token) throws InterruptedException {
        this.syncEventPublisher.accept((Object)new PartitionStatusUpdateEvent(token, PartitionStateEnum.READY_FOR_STREAMING));
    }
}

