/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db.model.schema;

import io.debezium.connector.spanner.db.model.schema.Column;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TableSchema {
    private final String name;
    private final Map<String, Column> columns;

    public TableSchema(String name, List<Column> columns) {
        this.name = name;
        this.columns = columns.stream().collect(Collectors.toMap(Column::getName, Function.identity()));
    }

    public String getName() {
        return this.name;
    }

    public List<Column> keyColumns() {
        return this.columns.values().stream().filter(Column::isPrimaryKey).collect(Collectors.toList());
    }

    public List<Column> columns() {
        return this.columns.values().stream().sorted(Comparator.comparing(Column::getOrdinalPosition)).collect(Collectors.toList());
    }

    public Column getColumn(String name) {
        return this.columns.get(name);
    }
}

