/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.schema;

import io.debezium.connector.spanner.db.metadata.TableId;
import io.debezium.connector.spanner.db.model.Mod;
import io.debezium.data.Envelope;
import io.debezium.schema.DataCollectionSchema;
import java.util.function.Function;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class KafkaSpannerTableSchema
implements DataCollectionSchema {
    private final TableId id;
    private final Schema keySchema;
    private final Envelope envelopeSchema;
    private final Schema valueSchema;
    private final Function<Mod, Struct> keyGenerator;
    private final Function<Mod, Struct> oldValueStructGenerator;
    private final Function<Mod, Struct> newValueStructGenerator;

    public KafkaSpannerTableSchema(TableId id, Schema keySchema, Function<Mod, Struct> keyGenerator, Envelope envelopeSchema, Schema valueSchema, Function<Mod, Struct> oldValueStructGenerator, Function<Mod, Struct> newValueStructGenerator) {
        this.id = id;
        this.keySchema = keySchema;
        this.envelopeSchema = envelopeSchema;
        this.valueSchema = valueSchema;
        this.keyGenerator = keyGenerator;
        this.oldValueStructGenerator = oldValueStructGenerator;
        this.newValueStructGenerator = newValueStructGenerator;
    }

    public TableId id() {
        return this.id;
    }

    public Schema valueSchema() {
        return this.valueSchema;
    }

    public Schema keySchema() {
        return this.keySchema;
    }

    public Envelope getEnvelopeSchema() {
        return this.envelopeSchema;
    }

    public Struct getKeyStructFromMod(Mod mod) {
        return mod == null ? null : this.keyGenerator.apply(mod);
    }

    public Struct getOldValueStructFromMod(Mod mod) {
        return mod == null ? null : this.oldValueStructGenerator.apply(mod);
    }

    public Struct getNewValueStructFromMod(Mod mod) {
        return mod == null ? null : this.newValueStructGenerator.apply(mod);
    }
}

