/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner;

import io.debezium.connector.spanner.db.model.event.ChangeStreamEvent;
import io.debezium.connector.spanner.metrics.MetricsEventPublisher;
import io.debezium.connector.spanner.metrics.event.SpannerEventQueueUpdateEvent;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;

public class StreamEventQueue {
    private final BlockingDeque<ChangeStreamEvent> queue;
    private final MetricsEventPublisher metricsEventPublisher;

    public StreamEventQueue(int capacity, MetricsEventPublisher metricsEventPublisher) {
        this.queue = new LinkedBlockingDeque<ChangeStreamEvent>(capacity);
        this.metricsEventPublisher = metricsEventPublisher;
        this.metricsEventPublisher.publishMetricEvent(new SpannerEventQueueUpdateEvent(this.queue.remainingCapacity() + this.queue.size(), this.queue.remainingCapacity()));
    }

    public void put(ChangeStreamEvent changeStreamEvent) throws InterruptedException {
        this.queue.put(changeStreamEvent);
        this.metricsEventPublisher.publishMetricEvent(new SpannerEventQueueUpdateEvent(this.queue.remainingCapacity() + this.queue.size(), this.queue.remainingCapacity()));
    }

    public ChangeStreamEvent take() throws InterruptedException {
        ChangeStreamEvent event = this.queue.take();
        this.metricsEventPublisher.publishMetricEvent(new SpannerEventQueueUpdateEvent(this.queue.remainingCapacity() + this.queue.size(), this.queue.remainingCapacity()));
        return event;
    }
}

