/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.config.validation;

import io.debezium.connector.spanner.config.BaseSpannerConnectorConfig;
import io.debezium.connector.spanner.config.validation.ConfigurationValidator;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartEndTimeValidator
implements ConfigurationValidator.Validator {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartEndTimeValidator.class);
    private final ConfigurationValidator.ValidationContext validationContext;
    private boolean result = true;

    public StartEndTimeValidator(ConfigurationValidator.ValidationContext validationContext) {
        this.validationContext = validationContext;
    }

    public static StartEndTimeValidator withContext(ConfigurationValidator.ValidationContext validationContext) {
        return new StartEndTimeValidator(validationContext);
    }

    @Override
    public boolean isSuccess() {
        return this.result;
    }

    @Override
    public ConfigurationValidator.Validator validate() {
        if (!this.canValidate()) {
            this.result = false;
            return this;
        }
        String startTime = this.validationContext.getString(BaseSpannerConnectorConfig.START_TIME);
        String endTime = this.validationContext.getString(BaseSpannerConnectorConfig.END_TIME);
        if (endTime != null && Instant.parse(startTime).isAfter(Instant.parse(endTime))) {
            String msg = "End time must be after start time";
            LOGGER.error(msg);
            this.validationContext.error(msg, BaseSpannerConnectorConfig.END_TIME);
            this.result = false;
        }
        return this;
    }

    private boolean canValidate() {
        return this.validationContext.getErrors(BaseSpannerConnectorConfig.START_TIME).isEmpty() && this.validationContext.getErrors(BaseSpannerConnectorConfig.END_TIME).isEmpty();
    }
}

