/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task.operation;

import io.debezium.connector.spanner.kafka.internal.model.PartitionState;
import io.debezium.connector.spanner.kafka.internal.model.TaskState;
import io.debezium.connector.spanner.task.TaskSyncContext;
import io.debezium.connector.spanner.task.operation.Operation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TakeSharedPartitionOperation
implements Operation {
    private static final Logger LOGGER = LoggerFactory.getLogger(TakeSharedPartitionOperation.class);
    private boolean isRequiredPublishSyncEvent = false;

    private TaskSyncContext takePartition(TaskSyncContext context) {
        TaskState taskState = context.getCurrentTaskState();
        List<PartitionState> sharedPartitions = TakeSharedPartitionOperation.findSharedPartition(context);
        Set tokens = taskState.getPartitions().stream().map(PartitionState::getToken).collect(Collectors.toSet());
        ArrayList<PartitionState> partitions = new ArrayList<PartitionState>(taskState.getPartitions());
        sharedPartitions.forEach(partitionState -> {
            if (!tokens.contains(partitionState.getToken())) {
                partitions.add((PartitionState)partitionState);
                this.isRequiredPublishSyncEvent = true;
                LOGGER.info("Task {} : taking shared partition {}", (Object)context.getTaskUid(), (Object)partitionState.getToken());
            }
        });
        return context.toBuilder().currentTaskState(taskState.toBuilder().partitions(partitions).build()).build();
    }

    private static List<PartitionState> findSharedPartition(TaskSyncContext context) {
        String currentTaskUid = context.getTaskUid();
        return Stream.concat(context.getTaskStates().values().stream(), Stream.of(context.getCurrentTaskState())).flatMap(taskState -> taskState.getSharedPartitions().stream()).filter(partitionState -> currentTaskUid.equals(partitionState.getAssigneeTaskUid())).collect(Collectors.toList());
    }

    @Override
    public boolean isRequiredPublishSyncEvent() {
        return this.isRequiredPublishSyncEvent;
    }

    @Override
    public TaskSyncContext doOperation(TaskSyncContext taskSyncContext) {
        return this.takePartition(taskSyncContext);
    }
}

