/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task.operation;

import io.debezium.connector.spanner.kafka.internal.model.PartitionState;
import io.debezium.connector.spanner.kafka.internal.model.TaskState;
import io.debezium.connector.spanner.task.TaskSyncContext;
import io.debezium.connector.spanner.task.operation.Operation;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClearSharedPartitionOperation
implements Operation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClearSharedPartitionOperation.class);
    private boolean isRequiredPublishSyncEvent = false;

    private TaskSyncContext clear(TaskSyncContext taskSyncContext) {
        TaskState currentTaskState = taskSyncContext.getCurrentTaskState();
        ArrayList removedSharedTokens = new ArrayList();
        Set otherTokens = taskSyncContext.getTaskStates().values().stream().flatMap(taskState -> taskState.getPartitions().stream()).map(PartitionState::getToken).collect(Collectors.toSet());
        Set otherSharedTokens = taskSyncContext.getTaskStates().values().stream().flatMap(taskState -> taskState.getSharedPartitions().stream()).collect(Collectors.toSet());
        Set otherTasks = taskSyncContext.getTaskStates().values().stream().map(taskState -> taskState.getTaskUid()).collect(Collectors.toSet());
        List currentSharedList = currentTaskState.getSharedPartitions().stream().collect(Collectors.toList());
        ArrayList<PartitionState> finalSharedList = new ArrayList<PartitionState>();
        boolean reassignedPartition = false;
        for (PartitionState sharedToken : currentSharedList) {
            if (otherTokens.contains(sharedToken.getToken())) {
                LOGGER.info("Task {}, removing token {} since it is already owned by other tasks {}", new Object[]{taskSyncContext.getTaskUid(), sharedToken, otherTasks});
                continue;
            }
            if (!otherTasks.contains(sharedToken.getAssigneeTaskUid())) {
                LOGGER.info("Task {}, token {} is not assigned to an alive task {}", new Object[]{taskSyncContext.getTaskUid(), sharedToken, otherTasks});
                boolean otherTaskSharesPartition = false;
                for (PartitionState otherSharedToken : otherSharedTokens) {
                    if (!otherSharedToken.getToken().equals(sharedToken.getToken()) || !otherTasks.contains(otherSharedToken.getAssigneeTaskUid())) continue;
                    LOGGER.info("Task {}, removing token {} since it is shared to another alive task {}", new Object[]{taskSyncContext.getTaskUid(), otherSharedToken, otherTasks});
                    otherTaskSharesPartition = true;
                    break;
                }
                if (otherTaskSharesPartition) continue;
                reassignedPartition = true;
                Random rand = new Random(System.currentTimeMillis());
                String[] otherTasksArray = (String[])otherTasks.toArray();
                String assigneeTaskUid = otherTasksArray[rand.nextInt(otherTasks.size())];
                LOGGER.info("Task {}, reassigning token {} to another task {} since it was not previously assigned to an alive task", new Object[]{taskSyncContext.getTaskUid(), sharedToken, assigneeTaskUid});
                finalSharedList.add(PartitionState.builder().token(sharedToken.getToken()).assigneeTaskUid(assigneeTaskUid).build());
                continue;
            }
            finalSharedList.add(sharedToken);
        }
        if (finalSharedList.size() != currentSharedList.size() || reassignedPartition) {
            this.isRequiredPublishSyncEvent = true;
            LOGGER.info("Task cleared some shared partitions, taskUid: {}, final shared list {}, original list {}", new Object[]{taskSyncContext.getTaskUid(), finalSharedList, currentTaskState.getSharedPartitions()});
        }
        return taskSyncContext.toBuilder().currentTaskState(currentTaskState.toBuilder().sharedPartitions(finalSharedList).build()).build();
    }

    @Override
    public boolean isRequiredPublishSyncEvent() {
        return this.isRequiredPublishSyncEvent;
    }

    @Override
    public TaskSyncContext doOperation(TaskSyncContext taskSyncContext) {
        return this.clear(taskSyncContext);
    }
}

