/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner;

import io.debezium.connector.spanner.PartitionManager;
import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.connector.spanner.SpannerPartition;
import io.debezium.connector.spanner.SpannerStreamingChangeEventSource;
import io.debezium.connector.spanner.StreamEventQueue;
import io.debezium.connector.spanner.context.offset.SpannerOffsetContext;
import io.debezium.connector.spanner.context.offset.SpannerOffsetContextFactory;
import io.debezium.connector.spanner.context.source.SourceInfoFactory;
import io.debezium.connector.spanner.db.metadata.SchemaRegistry;
import io.debezium.connector.spanner.db.stream.ChangeStream;
import io.debezium.connector.spanner.metrics.SpannerMeter;
import io.debezium.connector.spanner.processor.SpannerEventDispatcher;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.source.spi.SnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.SnapshotResult;

public class SpannerChangeEventSourceFactory
implements ChangeEventSourceFactory<SpannerPartition, SpannerOffsetContext> {
    private final SpannerConnectorConfig connectorConfig;
    private final SpannerEventDispatcher dispatcher;
    private final ErrorHandler errorHandler;
    private final SchemaRegistry schemaRegistry;
    private final SpannerMeter spannerMeter;
    private final ChangeStream changeStream;
    private final SourceInfoFactory sourceInfoFactory;
    private final PartitionManager partitionManager;

    public SpannerChangeEventSourceFactory(SpannerConnectorConfig connectorConfig, SpannerEventDispatcher dispatcher, ErrorHandler errorHandler, SchemaRegistry schemaRegistry, SpannerMeter spannerMeter, ChangeStream changeStream, SourceInfoFactory sourceInfoFactory, PartitionManager partitionManager) {
        this.connectorConfig = connectorConfig;
        this.dispatcher = dispatcher;
        this.errorHandler = errorHandler;
        this.schemaRegistry = schemaRegistry;
        this.spannerMeter = spannerMeter;
        this.changeStream = changeStream;
        this.sourceInfoFactory = sourceInfoFactory;
        this.partitionManager = partitionManager;
    }

    public SnapshotChangeEventSource<SpannerPartition, SpannerOffsetContext> getSnapshotChangeEventSource(SnapshotProgressListener snapshotProgressListener) {
        return (context, partition, previousOffset) -> SnapshotResult.skipped(null);
    }

    public SpannerStreamingChangeEventSource getStreamingChangeEventSource() {
        StreamEventQueue streamEventQueue = new StreamEventQueue(this.connectorConfig.queueCapacity(), this.spannerMeter.getMetricsEventPublisher());
        SpannerOffsetContextFactory offsetContextFactory = new SpannerOffsetContextFactory(this.sourceInfoFactory);
        return new SpannerStreamingChangeEventSource(this.errorHandler, this.changeStream, streamEventQueue, this.spannerMeter.getMetricsEventPublisher(), this.partitionManager, this.schemaRegistry, this.dispatcher, this.connectorConfig.isFinishingPartitionAfterCommit(), offsetContextFactory);
    }
}

