/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.transforms.timescaledb;

import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.connector.postgresql.transforms.timescaledb.AbstractTimescaleDbMetadata;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.relational.TableId;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryInformationSchemaMetadata
extends AbstractTimescaleDbMetadata {
    private static final String CATALOG_SCHEMA = "_timescaledb_catalog";
    private static final String QUERY_HYPERTABLE_TO_AGGREGATE = String.format("SELECT ht.schema_name, ht.table_name, agg.user_view_schema, agg.user_view_name FROM %s.continuous_agg agg LEFT JOIN %s.hypertable ht ON agg.mat_hypertable_id = ht.id", "_timescaledb_catalog", "_timescaledb_catalog");
    private static final String QUERY_CHUNK_TO_HYPERTABLE = String.format("SELECT c.schema_name, c.table_name, ht.schema_name, ht.table_name FROM %s.chunk c LEFT JOIN %s.hypertable ht ON c.hypertable_id = ht.id", "_timescaledb_catalog", "_timescaledb_catalog");
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryInformationSchemaMetadata.class);
    private final PostgresConnection connection;
    private final Map<TableId, TableId> chunkToHypertable = new HashMap<TableId, TableId>();
    private final Map<TableId, TableId> hypertableToAggregate = new HashMap<TableId, TableId>();

    public QueryInformationSchemaMetadata(Configuration config) {
        super(config);
        this.connection = new PostgresConnection(JdbcConfiguration.adapt((Configuration)config.subset("database.", true).merge(new Configuration[]{config.subset("driver.", true)})), "Debezium TimescaleDB metadata");
    }

    @Override
    public Optional<TableId> hypertableId(TableId chunkId) {
        TableId hypertableId = this.chunkToHypertable.get(chunkId);
        if (hypertableId != null) {
            return Optional.of(hypertableId);
        }
        LOGGER.debug("Chunk '{}' not found, querying the catalog", (Object)chunkId);
        this.loadTimescaleMetadata();
        return Optional.ofNullable(this.chunkToHypertable.get(chunkId));
    }

    @Override
    public Optional<TableId> aggregateId(TableId hypertableId) {
        return Optional.ofNullable(this.hypertableToAggregate.get(hypertableId));
    }

    @Override
    public void close() throws IOException {
        this.connection.close();
    }

    private void loadTimescaleMetadata() {
        try {
            this.chunkToHypertable.clear();
            this.connection.query(QUERY_CHUNK_TO_HYPERTABLE, rs -> {
                while (rs.next()) {
                    this.chunkToHypertable.put(new TableId(null, rs.getString(1), rs.getString(2)), new TableId(null, rs.getString(3), rs.getString(4)));
                }
            });
            this.hypertableToAggregate.clear();
            this.connection.query(QUERY_HYPERTABLE_TO_AGGREGATE, rs -> {
                while (rs.next()) {
                    this.hypertableToAggregate.put(new TableId(null, rs.getString(1), rs.getString(2)), new TableId(null, rs.getString(3), rs.getString(4)));
                }
            });
        }
        catch (SQLException e) {
            throw new DebeziumException("Failed to read TimescaleDB metadata", (Throwable)e);
        }
    }
}

