/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.connector.postgresql.PgSnapshot;
import io.debezium.pipeline.source.snapshot.incremental.AbstractIncrementalSnapshotContext;
import io.debezium.pipeline.spi.OffsetContext;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresReadOnlyIncrementalSnapshotContext<T>
extends AbstractIncrementalSnapshotContext<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresReadOnlyIncrementalSnapshotContext.class);
    private PgSnapshot lowWatermark;
    private PgSnapshot highWatermark;
    private PgSnapshot previousHighWatermark;
    private PgSnapshot previousLowWatermark;

    public PostgresReadOnlyIncrementalSnapshotContext() {
        this(false);
    }

    public PostgresReadOnlyIncrementalSnapshotContext(boolean useCatalogBeforeSchema) {
        super(useCatalogBeforeSchema);
    }

    public static <U> PostgresReadOnlyIncrementalSnapshotContext<U> load(Map<String, ?> offsets) {
        return PostgresReadOnlyIncrementalSnapshotContext.load(offsets, false);
    }

    public static <U> PostgresReadOnlyIncrementalSnapshotContext<U> load(Map<String, ?> offsets, boolean useCatalogBeforeSchema) {
        PostgresReadOnlyIncrementalSnapshotContext context = new PostgresReadOnlyIncrementalSnapshotContext(useCatalogBeforeSchema);
        PostgresReadOnlyIncrementalSnapshotContext.init(context, offsets);
        return context;
    }

    public PgSnapshot getLowWatermark() {
        return this.lowWatermark;
    }

    public void setLowWatermark(PgSnapshot lowWatermark) {
        LOGGER.trace("Setting low watermark to {}", (Object)lowWatermark);
        this.lowWatermark = lowWatermark;
    }

    public PgSnapshot getHighWatermark() {
        return this.highWatermark;
    }

    public void setHighWatermark(PgSnapshot highWatermark) {
        LOGGER.trace("Setting high watermark to {}", (Object)highWatermark);
        this.highWatermark = highWatermark;
    }

    public void updateWindowState(OffsetContext offsetContext) {
        Long eventTxId = offsetContext.getSourceInfo().getInt64("txId");
        LOGGER.trace("Received event with TxId {}", (Object)eventTxId);
        LOGGER.trace("Updating window. Window opened: {}, low watermark {}, high watermark {}", new Object[]{this.windowOpened, this.lowWatermark, this.highWatermark});
        if (!this.windowOpened && this.lowWatermark != null) {
            boolean pastLowWatermark;
            boolean bl = pastLowWatermark = eventTxId >= this.lowWatermark.getXMin();
            if (pastLowWatermark) {
                LOGGER.debug("Current event txId {}, low watermark {}", (Object)eventTxId, (Object)this.lowWatermark);
                this.windowOpened = true;
            }
        }
        if (this.windowOpened && this.highWatermark != null) {
            boolean pastHighWatermark;
            boolean bl = pastHighWatermark = eventTxId > Math.max(this.highWatermark.getXMax(), this.lowWatermark.getXMax());
            if (pastHighWatermark) {
                LOGGER.debug("Current event txId {}, high watermark {}", (Object)eventTxId, (Object)this.highWatermark);
                this.closeWindow();
            }
        }
    }

    public boolean isWindowClosed() {
        return !this.windowOpened;
    }

    public void closeWindow() {
        LOGGER.trace("Window closed. Low and High watermark cleaned");
        this.windowOpened = false;
        this.previousHighWatermark = this.highWatermark;
        this.highWatermark = null;
        this.previousLowWatermark = this.lowWatermark;
        this.lowWatermark = null;
    }

    public boolean isTransactionVisible(Long eventTxId) {
        if (this.highWatermark == null) {
            return false;
        }
        return eventTxId.compareTo(this.highWatermark.getXMin()) <= 0;
    }

    public boolean watermarksChanged() {
        LOGGER.trace("previousLowWatermark {}, lowWatermark {}, previousHighWatermark {}, highWatermark {}", new Object[]{this.previousLowWatermark, this.lowWatermark, this.previousHighWatermark, this.highWatermark});
        return !this.previousLowWatermark.equals(this.lowWatermark) || !this.previousHighWatermark.equals(this.highWatermark);
    }
}

