/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.DebeziumException;
import io.debezium.bean.StandardBeanNames;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.connector.postgresql.Module;
import io.debezium.connector.postgresql.PostgresChangeEventSourceCoordinator;
import io.debezium.connector.postgresql.PostgresChangeEventSourceFactory;
import io.debezium.connector.postgresql.PostgresChangeRecordEmitter;
import io.debezium.connector.postgresql.PostgresConnector;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.PostgresErrorHandler;
import io.debezium.connector.postgresql.PostgresEventDispatcher;
import io.debezium.connector.postgresql.PostgresEventMetadataProvider;
import io.debezium.connector.postgresql.PostgresOffsetContext;
import io.debezium.connector.postgresql.PostgresPartition;
import io.debezium.connector.postgresql.PostgresSchema;
import io.debezium.connector.postgresql.PostgresTaskContext;
import io.debezium.connector.postgresql.PostgresValueConverter;
import io.debezium.connector.postgresql.TypeRegistry;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.connector.postgresql.connection.PostgresDefaultValueConverter;
import io.debezium.connector.postgresql.connection.ReplicationConnection;
import io.debezium.connector.postgresql.spi.SlotCreationResult;
import io.debezium.connector.postgresql.spi.SlotState;
import io.debezium.document.DocumentReader;
import io.debezium.jdbc.DefaultMainConnectionProvidingConnectionFactory;
import io.debezium.jdbc.MainConnectionProvidingConnectionFactory;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.metrics.DefaultChangeEventSourceMetricsFactory;
import io.debezium.pipeline.metrics.spi.ChangeEventSourceMetricsFactory;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.signal.SignalProcessor;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionFilters;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.SchemaFactory;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.spi.snapshot.Snapshotter;
import io.debezium.spi.topic.TopicNamingStrategy;
import io.debezium.util.Clock;
import io.debezium.util.LoggingContext;
import io.debezium.util.Metronome;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.RetriableException;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresConnectorTask
extends BaseSourceTask<PostgresPartition, PostgresOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresConnectorTask.class);
    private static final String CONTEXT_NAME = "postgres-connector-task";
    private volatile PostgresTaskContext taskContext;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile PostgresConnection jdbcConnection;
    private volatile PostgresConnection beanRegistryJdbcConnection;
    private volatile ReplicationConnection replicationConnection = null;
    private volatile ErrorHandler errorHandler;
    private volatile PostgresSchema schema;
    private Partition.Provider<PostgresPartition> partitionProvider = null;
    private OffsetContext.Loader<PostgresOffsetContext> offsetContextLoader = null;
    private final ReentrantLock commitLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeEventSourceCoordinator<PostgresPartition, PostgresOffsetContext> start(Configuration config) {
        Charset databaseCharset;
        PostgresConnectorConfig connectorConfig = new PostgresConnectorConfig(config);
        TopicNamingStrategy topicNamingStrategy = connectorConfig.getTopicNamingStrategy(CommonConnectorConfig.TOPIC_NAMING_STRATEGY);
        SchemaNameAdjuster schemaNameAdjuster = connectorConfig.schemaNameAdjuster();
        try (PostgresConnection tempConnection = new PostgresConnection(connectorConfig.getJdbcConfig(), "Debezium General");){
            databaseCharset = tempConnection.getDatabaseCharset();
        }
        PostgresConnection.PostgresValueConverterBuilder valueConverterBuilder = typeRegistry -> PostgresValueConverter.of(connectorConfig, databaseCharset, typeRegistry);
        DefaultMainConnectionProvidingConnectionFactory connectionFactory = new DefaultMainConnectionProvidingConnectionFactory(() -> new PostgresConnection(connectorConfig.getJdbcConfig(), valueConverterBuilder, "Debezium General"));
        this.jdbcConnection = (PostgresConnection)connectionFactory.mainConnection();
        try {
            this.jdbcConnection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new DebeziumException((Throwable)e);
        }
        TypeRegistry typeRegistry2 = this.jdbcConnection.getTypeRegistry();
        PostgresDefaultValueConverter defaultValueConverter = this.jdbcConnection.getDefaultValueConverter();
        PostgresValueConverter valueConverter = valueConverterBuilder.build(typeRegistry2);
        this.schema = new PostgresSchema(connectorConfig, defaultValueConverter, (TopicNamingStrategy<TableId>)topicNamingStrategy, valueConverter);
        this.taskContext = new PostgresTaskContext(connectorConfig, this.schema, (TopicNamingStrategy<TableId>)topicNamingStrategy);
        this.partitionProvider = new PostgresPartition.Provider(connectorConfig, config);
        this.offsetContextLoader = new PostgresOffsetContext.Loader(connectorConfig);
        Offsets previousOffsets = this.getPreviousOffsets(this.partitionProvider, this.offsetContextLoader);
        Clock clock = Clock.system();
        PostgresOffsetContext previousOffset = (PostgresOffsetContext)previousOffsets.getTheOnlyOffset();
        this.beanRegistryJdbcConnection = (PostgresConnection)connectionFactory.newConnection();
        connectorConfig.getBeanRegistry().add(StandardBeanNames.CONFIGURATION, (Object)config);
        connectorConfig.getBeanRegistry().add("ConnectorConfig", (Object)connectorConfig);
        connectorConfig.getBeanRegistry().add("Schema", (Object)this.schema);
        connectorConfig.getBeanRegistry().add(StandardBeanNames.JDBC_CONNECTION, (Object)this.beanRegistryJdbcConnection);
        connectorConfig.getBeanRegistry().add(StandardBeanNames.VALUE_CONVERTER, (Object)valueConverter);
        connectorConfig.getBeanRegistry().add(StandardBeanNames.OFFSETS, (Object)previousOffsets);
        this.registerServiceProviders(connectorConfig.getServiceRegistry());
        SnapshotterService snapshotterService = (SnapshotterService)connectorConfig.getServiceRegistry().tryGetService(SnapshotterService.class);
        Snapshotter snapshotter = snapshotterService.getSnapshotter();
        try {
            PostgresConnectorTask.checkWalLevel(this.beanRegistryJdbcConnection, snapshotterService);
        }
        catch (SQLException e) {
            LOGGER.error("Failed testing connection for {} with user '{}'", new Object[]{this.beanRegistryJdbcConnection.connectionString(), this.beanRegistryJdbcConnection.username(), e});
        }
        this.validateAndLoadSchemaHistory((CommonConnectorConfig)connectorConfig, this.jdbcConnection::validateLogPosition, previousOffsets, (DatabaseSchema)this.schema, snapshotter);
        LoggingContext.PreviousContext previousContext = this.taskContext.configureLoggingContext(CONTEXT_NAME);
        try {
            SlotState slotInfo = null;
            try {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(this.jdbcConnection.serverInfo().toString());
                }
                slotInfo = this.jdbcConnection.getReplicationSlotState(connectorConfig.slotName(), connectorConfig.plugin().getPostgresPluginName());
            }
            catch (SQLException e) {
                LOGGER.warn("unable to load info of replication slot, Debezium will try to create the slot");
            }
            if (previousOffset == null) {
                LOGGER.info("No previous offset found");
            } else {
                LOGGER.info("Found previous offset {}", (Object)previousOffset);
            }
            SlotCreationResult slotCreatedInfo = null;
            if (snapshotter.shouldStream()) {
                this.replicationConnection = this.createReplicationConnection(this.taskContext, connectorConfig.maxRetries(), connectorConfig.retryDelay());
                if (slotInfo == null) {
                    try {
                        slotCreatedInfo = this.replicationConnection.createReplicationSlot().orElse(null);
                    }
                    catch (SQLException ex) {
                        Object message = "Creation of replication slot failed";
                        if (ex.getMessage().contains("already exists")) {
                            message = (String)message + "; when setting up multiple connectors for the same database host, please make sure to use a distinct replication slot name for each.";
                        }
                        throw new DebeziumException((String)message, (Throwable)ex);
                    }
                } else {
                    slotCreatedInfo = null;
                }
            }
            try {
                this.jdbcConnection.commit();
            }
            catch (SQLException e) {
                throw new DebeziumException((Throwable)e);
            }
            this.queue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).maxQueueSizeInBytes(connectorConfig.getMaxQueueSizeInBytes()).loggingContextSupplier(() -> this.taskContext.configureLoggingContext(CONTEXT_NAME)).build();
            this.errorHandler = new PostgresErrorHandler(connectorConfig, this.queue, this.errorHandler);
            PostgresEventMetadataProvider metadataProvider = new PostgresEventMetadataProvider();
            SignalProcessor signalProcessor = new SignalProcessor(PostgresConnector.class, (CommonConnectorConfig)connectorConfig, Map.of(), this.getAvailableSignalChannels(), DocumentReader.defaultReader(), previousOffsets);
            PostgresEventDispatcher<TableId> dispatcher = new PostgresEventDispatcher<TableId>(connectorConfig, (TopicNamingStrategy<TableId>)topicNamingStrategy, (DatabaseSchema<TableId>)this.schema, this.queue, (DataCollectionFilters.DataCollectionFilter<TableId>)connectorConfig.getTableFilters().dataCollectionFilter(), DataChangeEvent::new, (EventDispatcher.InconsistentSchemaHandler<PostgresPartition, TableId>)((EventDispatcher.InconsistentSchemaHandler)PostgresChangeRecordEmitter::updateSchema), metadataProvider, connectorConfig.createHeartbeat(topicNamingStrategy, schemaNameAdjuster, () -> new PostgresConnection(connectorConfig.getJdbcConfig(), "Debezium General"), exception -> {
                String sqlErrorId;
                switch (sqlErrorId = exception.getSQLState()) {
                    case "57P01": {
                        throw new DebeziumException("Could not execute heartbeat action query (Error: " + sqlErrorId + ")", (Throwable)exception);
                    }
                    case "57P03": {
                        throw new RetriableException("Could not execute heartbeat action query (Error: " + sqlErrorId + ")", (Throwable)exception);
                    }
                }
            }), schemaNameAdjuster, (SignalProcessor<PostgresPartition, PostgresOffsetContext>)signalProcessor);
            NotificationService notificationService = new NotificationService(this.getNotificationChannels(), (CommonConnectorConfig)connectorConfig, SchemaFactory.get(), arg_0 -> dispatcher.enqueueNotification(arg_0));
            PostgresChangeEventSourceCoordinator coordinator = new PostgresChangeEventSourceCoordinator((Offsets<PostgresPartition, PostgresOffsetContext>)previousOffsets, this.errorHandler, (Class<? extends SourceConnector>)PostgresConnector.class, (CommonConnectorConfig)connectorConfig, new PostgresChangeEventSourceFactory(connectorConfig, snapshotterService, (MainConnectionProvidingConnectionFactory<PostgresConnection>)connectionFactory, this.errorHandler, dispatcher, clock, this.schema, this.taskContext, this.replicationConnection, slotCreatedInfo, slotInfo), (ChangeEventSourceMetricsFactory<PostgresPartition>)new DefaultChangeEventSourceMetricsFactory(), (EventDispatcher<PostgresPartition, ?>)dispatcher, (DatabaseSchema<?>)this.schema, snapshotterService, slotInfo, (SignalProcessor<PostgresPartition, PostgresOffsetContext>)signalProcessor, (NotificationService<PostgresPartition, PostgresOffsetContext>)notificationService);
            coordinator.start(this.taskContext, (ChangeEventQueueMetrics)this.queue, metadataProvider);
            PostgresChangeEventSourceCoordinator postgresChangeEventSourceCoordinator = coordinator;
            return postgresChangeEventSourceCoordinator;
        }
        finally {
            previousContext.restore();
        }
    }

    public ReplicationConnection createReplicationConnection(PostgresTaskContext taskContext, int maxRetries, Duration retryDelay) throws ConnectException {
        Metronome metronome = Metronome.parker((Duration)retryDelay, (Clock)Clock.SYSTEM);
        short retryCount = 0;
        ReplicationConnection replicationConnection = null;
        while (retryCount <= maxRetries) {
            try {
                return taskContext.createReplicationConnection(this.jdbcConnection);
            }
            catch (SQLException ex) {
                retryCount = (short)(retryCount + 1);
                if (retryCount > maxRetries) {
                    LOGGER.error("Too many errors connecting to server. All {} retries failed.", (Object)maxRetries);
                    throw new ConnectException((Throwable)ex);
                }
                LOGGER.warn("Error connecting to server; will attempt retry {} of {} after {} seconds. Exception message: {}", new Object[]{retryCount, maxRetries, retryDelay.getSeconds(), ex.getMessage()});
                try {
                    metronome.pause();
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Connection retry sleep interrupted by exception: " + e);
                    Thread.currentThread().interrupt();
                }
            }
        }
        return replicationConnection;
    }

    public List<SourceRecord> doPoll() throws InterruptedException {
        List records = this.queue.poll();
        List<SourceRecord> sourceRecords = records.stream().map(DataChangeEvent::getRecord).collect(Collectors.toList());
        return sourceRecords;
    }

    protected void doStop() {
        try {
            if (this.replicationConnection != null) {
                this.replicationConnection.close();
            }
        }
        catch (Exception e) {
            LOGGER.trace("Error while closing replication connection", (Throwable)e);
        }
        try {
            if (this.beanRegistryJdbcConnection != null) {
                this.beanRegistryJdbcConnection.close();
            }
        }
        catch (Exception e) {
            LOGGER.trace("Error while closing JDBC bean registry connection", (Throwable)e);
        }
        if (this.jdbcConnection != null) {
            this.jdbcConnection.close();
        }
        if (this.schema != null) {
            this.schema.close();
        }
    }

    public String version() {
        return Module.version();
    }

    protected Iterable<Field> getAllConfigurationFields() {
        return PostgresConnectorConfig.ALL_FIELDS;
    }

    public void commitRecord(SourceRecord record, RecordMetadata metadata) throws InterruptedException {
    }

    public void commitRecord(SourceRecord record) throws InterruptedException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commit() throws InterruptedException {
        boolean locked = this.commitLock.tryLock();
        if (locked) {
            try {
                Offsets offsets;
                if (this.coordinator == null || (offsets = this.getPreviousOffsets(this.partitionProvider, this.offsetContextLoader)).getOffsets() == null) return;
                offsets.getOffsets().entrySet().stream().filter(e -> e.getValue() != null).forEach(entry -> {
                    Map<String, String> partition = ((PostgresPartition)((Object)((Object)entry.getKey()))).getSourcePartition();
                    Map<String, ?> lastOffset = ((PostgresOffsetContext)((Object)((Object)entry.getValue()))).getOffset();
                    LOGGER.debug("Committing offset '{}' for partition '{}'", partition, lastOffset);
                    this.coordinator.commitOffset(partition, lastOffset);
                });
                return;
            }
            finally {
                this.commitLock.unlock();
            }
        } else {
            LOGGER.warn("Couldn't commit processed log positions with the source database due to a concurrent connector shutdown or restart");
        }
    }

    public PostgresTaskContext getTaskContext() {
        return this.taskContext;
    }

    private static void checkWalLevel(PostgresConnection connection, SnapshotterService snapshotterService) throws SQLException {
        String walLevel = (String)connection.queryAndMap("SHOW wal_level", connection.singleResultMapper(rs -> rs.getString("wal_level"), "Could not fetch wal_level"));
        if (!"logical".equals(walLevel)) {
            if (snapshotterService.getSnapshotter() != null && snapshotterService.getSnapshotter().shouldStream()) {
                throw new SQLException("Postgres server wal_level property must be 'logical' but is: '" + walLevel + "'");
            }
            LOGGER.warn("WAL_LEVEL check failed but this is ignored as CDC was not requested");
        }
    }
}

