/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.postgresql.LogicalDecodingMessageFilter;
import io.debezium.connector.postgresql.Module;
import io.debezium.connector.postgresql.PostgresSourceInfoStructMaker;
import io.debezium.connector.postgresql.ReplicaIdentityMapper;
import io.debezium.connector.postgresql.connection.MessageDecoder;
import io.debezium.connector.postgresql.connection.MessageDecoderContext;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.connector.postgresql.connection.pgoutput.PgOutputMessageDecoder;
import io.debezium.connector.postgresql.connection.pgproto.PgProtoMessageDecoder;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.relational.ColumnFilterMode;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.util.Strings;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresConnectorConfig
extends RelationalDatabaseConnectorConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresConnectorConfig.class);
    protected static final String DATABASE_CONFIG_PREFIX = "database.";
    protected static final int DEFAULT_PORT = 5432;
    protected static final int DEFAULT_SNAPSHOT_FETCH_SIZE = 10240;
    protected static final int DEFAULT_MAX_RETRIES = 6;
    public static final Field PORT = RelationalDatabaseConnectorConfig.PORT.withDefault(5432);
    public static final Field PLUGIN_NAME = Field.create((String)"plugin.name").withDisplayName("Plugin").withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_REPLICATION, (int)0)).withEnum(LogicalDecoder.class, (Enum)LogicalDecoder.DECODERBUFS).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The name of the Postgres logical decoding plugin installed on the server. Supported values are '" + LogicalDecoder.DECODERBUFS.getValue() + "' and '" + LogicalDecoder.PGOUTPUT.getValue() + "'. Defaults to '" + LogicalDecoder.DECODERBUFS.getValue() + "'.");
    public static final Field SLOT_NAME = Field.create((String)"slot.name").withDisplayName("Slot").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_REPLICATION, (int)1)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDefault("debezium").withValidation(new Field.Validator[]{PostgresConnectorConfig::validateReplicationSlotName}).withDescription("The name of the Postgres logical decoding slot created for streaming changes from a plugin. Defaults to 'debezium");
    public static final Field DROP_SLOT_ON_STOP = Field.create((String)"slot.drop.on.stop").withDisplayName("Drop slot on stop").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_REPLICATION, (int)3)).withDefault(false).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Whether or not to drop the logical replication slot when the connector finishes orderly. By default the replication is kept so that on restart progress can resume from the last recorded location");
    public static final Field SLOT_SEEK_TO_KNOWN_OFFSET = Field.createInternal((String)"slot.seek.to.known.offset.on.start").withDisplayName("Seek to last known offset on the replication slot").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_REPLICATION, (int)3)).withDefault(false).withImportance(ConfigDef.Importance.LOW).withInvisibleRecommender().withDescription("Whether or not to seek to the last known offset on the replication slot.Enabling this option results in startup failure if the slot is re-created instead of data loss.");
    public static final Field PUBLICATION_NAME = Field.create((String)"publication.name").withDisplayName("Publication").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_REPLICATION, (int)8)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDefault("dbz_publication").withDescription("The name of the Postgres 10+ publication used for streaming changes from a plugin. Defaults to 'dbz_publication'");
    public static final Field PUBLICATION_AUTOCREATE_MODE = Field.create((String)"publication.autocreate.mode").withDisplayName("Publication Auto Create Mode").withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_REPLICATION, (int)9)).withEnum(AutoCreateMode.class, (Enum)AutoCreateMode.ALL_TABLES).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Applies only when streaming changes using pgoutput.Determine how creation of a publication should work, the default is all_tables.DISABLED - The connector will not attempt to create a publication at all. The expectation is that the user has created the publication up-front. If the publication isn't found to exist upon startup, the connector will throw an exception and stop.ALL_TABLES - If no publication exists, the connector will create a new publication for all tables. Note this requires that the configured user has access. If the publication already exists, it will be used. i.e CREATE PUBLICATION <publication_name> FOR ALL TABLES;FILTERED - If no publication exists, the connector will create a new publication for all those tables matchingthe current filter configuration (see table/database include/exclude list properties). If the publication already exists, it will be used. i.e CREATE PUBLICATION <publication_name> FOR TABLE <tbl1, tbl2, etc>");
    public static final Field REPLICA_IDENTITY_AUTOSET_VALUES = Field.create((String)"replica.identity.autoset.values").withDisplayName("Replica Identity Auto Set Values").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_REPLICATION, (int)10)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(new Field.Validator[]{PostgresConnectorConfig::validateReplicaAutoSetField}).withDescription("Applies only when streaming changes using pgoutput.Determines the value for Replica Identity at table level. This option will overwrite the existing value in databaseA comma-separated list of regular expressions that match fully-qualified tables and Replica Identity value to be used in the table. Each expression must match the pattern '<fully-qualified table name>:<replica identity>', where the table names could be defined as (SCHEMA_NAME.TABLE_NAME), and the replica identity values are: DEFAULT - Records the old values of the columns of the primary key, if any. This is the default for non-system tables.INDEX index_name - Records the old values of the columns covered by the named index, that must be unique, not partial, not deferrable, and include only columns marked NOT NULL. If this index is dropped, the behavior is the same as NOTHING.FULL - Records the old values of all columns in the row.NOTHING - Records no information about the old row. This is the default for system tables.");
    public static final Field STREAM_PARAMS = Field.create((String)"slot.stream.params").withDisplayName("Optional parameters to pass to the logical decoder when the stream is started.").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_REPLICATION, (int)2)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withDescription("Any optional parameters used by logical decoding plugin. Semi-colon separated. E.g. 'add-tables=public.table,public.table2;include-lsn=true'");
    public static final Field MAX_RETRIES = Field.create((String)"slot.max.retries").withDisplayName("Retry count").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_REPLICATION, (int)4)).withImportance(ConfigDef.Importance.LOW).withDefault(6).withValidation(new Field.Validator[]{Field::isInteger}).withDescription("How many times to retry connecting to a replication slot when an attempt fails.");
    public static final Field RETRY_DELAY_MS = Field.create((String)"slot.retry.delay.ms").withDisplayName("Retry delay").withType(ConfigDef.Type.LONG).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_REPLICATION, (int)5)).withImportance(ConfigDef.Importance.LOW).withDefault(Duration.ofSeconds(10L).toMillis()).withValidation(new Field.Validator[]{Field::isInteger}).withDescription("Time to wait between retry attempts when the connector fails to connect to a replication slot, given in milliseconds. Defaults to 10 seconds (10,000 ms).");
    public static final Field ON_CONNECT_STATEMENTS = Field.create((String)("database." + JdbcConfiguration.ON_CONNECT_STATEMENTS)).withDisplayName("Initial statements").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)1)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withDescription("A semicolon separated list of SQL statements to be executed when a JDBC connection to the database is established. Note that the connector may establish JDBC connections at its own discretion, so this should typically be used for configuration of session parameters only, but not for executing DML statements. Use doubled semicolon (';;') to use a semicolon as a character and not as a delimiter.");
    public static final Field SSL_MODE = Field.create((String)"database.sslmode").withDisplayName("SSL mode").withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_SSL, (int)0)).withEnum(SecureConnectionMode.class, (Enum)SecureConnectionMode.PREFER).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Whether to use an encrypted connection to Postgres. Options include: 'disable' (the default) to use an unencrypted connection; 'allow' to try and use an unencrypted connection first and, failing that, a secure (encrypted) connection; 'prefer' (the default) to try and use a secure (encrypted) connection first and, failing that, an unencrypted connection; 'require' to use a secure (encrypted) connection, and fail if one cannot be established; 'verify-ca' like 'required' but additionally verify the server TLS certificate against the configured Certificate Authority (CA) certificates, or fail if no valid matching CA certificates are found; or 'verify-full' like 'verify-ca' but additionally verify that the server certificate matches the host to which the connection is attempted.");
    public static final Field SSL_CLIENT_CERT = Field.create((String)"database.sslcert").withDisplayName("SSL Client Certificate").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_SSL, (int)1)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("File containing the SSL Certificate for the client. See the Postgres SSL docs for further information");
    public static final Field SSL_CLIENT_KEY = Field.create((String)"database.sslkey").withDisplayName("SSL Client Key").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_SSL, (int)4)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("File containing the SSL private key for the client. See the Postgres SSL docs for further information");
    public static final Field SSL_CLIENT_KEY_PASSWORD = Field.create((String)"database.sslpassword").withDisplayName("SSL Client Key Password").withType(ConfigDef.Type.PASSWORD).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_SSL, (int)2)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Password to access the client private key from the file specified by 'database.sslkey'. See the Postgres SSL docs for further information");
    public static final Field SSL_ROOT_CERT = Field.create((String)"database.sslrootcert").withDisplayName("SSL Root Certificate").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_SSL, (int)3)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("File containing the root certificate(s) against which the server is validated. See the Postgres JDBC SSL docs for further information");
    public static final Field SSL_SOCKET_FACTORY = Field.create((String)"database.sslfactory").withDisplayName("SSL Root Certificate").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_SSL, (int)5)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("A name of class to that creates SSL Sockets. Use org.postgresql.ssl.NonValidatingFactory to disable SSL validation in development environments");
    public static final Field SNAPSHOT_MODE = Field.create((String)"snapshot.mode").withDisplayName("Snapshot mode").withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_SNAPSHOT, (int)0)).withEnum(SnapshotMode.class, (Enum)SnapshotMode.INITIAL).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The criteria for running a snapshot upon startup of the connector. Select one of the following snapshot options: 'always': The connector runs a snapshot every time that it starts. After the snapshot completes, the connector begins to stream changes from the transaction log.; 'initial' (default): If the connector does not detect any offsets for the logical server name, it runs a snapshot that captures the current full state of the configured tables. After the snapshot completes, the connector begins to stream changes from the transaction log. 'initial_only': The connector performs a snapshot as it does for the 'initial' option, but after the connector completes the snapshot, it stops, and does not stream changes from the transaction log.; 'never': The connector does not run a snapshot. Upon first startup, the connector immediately begins reading from the beginning of the transaction log. 'exported': This option is deprecated; use 'initial' instead.; 'custom': The connector loads a custom class  to specify how the connector performs snapshots. For more information, see Custom snapshotter SPI in the PostgreSQL connector documentation.");
    public static final Field SNAPSHOT_LOCKING_MODE = Field.create((String)"snapshot.locking.mode").withDisplayName("Snapshot locking mode").withEnum(SnapshotLockingMode.class, (Enum)SnapshotLockingMode.NONE).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_SNAPSHOT, (int)13)).withDescription("Controls how the connector holds locks on tables while performing the schema snapshot. The 'shared' which means the connector will hold a table lock that prevents exclusive table access for just the initial portion of the snapshot while the database schemas and other metadata are being read. The remaining work in a snapshot involves selecting all rows from each table, and this is done using a flashback query that requires no locks. However, in some cases it may be desirable to avoid locks entirely which can be done by specifying 'none'. This mode is only safe to use if no schema changes are happening while the snapshot is taken.");
    public static final Field LOGICAL_DECODING_MESSAGE_PREFIX_EXCLUDE_LIST = Field.create((String)"message.prefix.exclude.list").withDisplayName("Exclude Logical Decoding Message Prefixes").withType(ConfigDef.Type.LIST).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)25)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(new Field.Validator[]{Field::isListOfRegex, PostgresConnectorConfig::validateLogicalDecodingMessageExcludeList}).withDescription("A comma-separated list of regular expressions that match the logical decoding message prefixes to be excluded from monitoring.");
    public static final Field LOGICAL_DECODING_MESSAGE_PREFIX_INCLUDE_LIST = Field.create((String)"message.prefix.include.list").withDisplayName("Include Logical Decoding Message Prefixes").withType(ConfigDef.Type.LIST).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)24)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(new Field.Validator[]{Field::isListOfRegex}).withDescription("A comma-separated list of regular expressions that match the logical decoding message prefixes to be monitored. All prefixes are monitored by default.");
    public static final Field HSTORE_HANDLING_MODE = Field.create((String)"hstore.handling.mode").withDisplayName("HStore Handling").withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)22)).withEnum(HStoreHandlingMode.class, (Enum)HStoreHandlingMode.JSON).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("Specify how HSTORE columns should be represented in change events, including: 'json' represents values as string-ified JSON (default); 'map' represents values as a key/value map");
    public static final Field INTERVAL_HANDLING_MODE = Field.create((String)"interval.handling.mode").withDisplayName("Interval Handling").withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)21)).withEnum(IntervalHandlingMode.class, (Enum)IntervalHandlingMode.NUMERIC).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("Specify how INTERVAL columns should be represented in change events, including: 'string' represents values as an exact ISO formatted string; 'numeric' (default) represents values using the inexact conversion into microseconds");
    public static final Field STATUS_UPDATE_INTERVAL_MS = Field.create((String)"status.update.interval.ms").withDisplayName("Status update interval (ms)").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_REPLICATION, (int)6)).withDefault(10000).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Frequency for sending replication connection status updates to the server, given in milliseconds. Defaults to 10 seconds (10,000 ms).").withValidation(new Field.Validator[]{Field::isPositiveInteger});
    public static final Field TCP_KEEPALIVE = Field.create((String)"database.tcpKeepAlive").withDisplayName("TCP keep-alive probe").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)0)).withDefault(true).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Enable or disable TCP keep-alive probe to avoid dropping TCP connection").withValidation(new Field.Validator[]{Field::isBoolean});
    public static final Field INCLUDE_UNKNOWN_DATATYPES = Field.create((String)"include.unknown.datatypes").withDisplayName("Include unknown datatypes").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)1)).withDefault(false).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Specify whether the fields of data type not supported by Debezium should be processed: 'false' (the default) omits the fields; 'true' converts the field into an implementation dependent binary representation.");
    public static final Field SCHEMA_REFRESH_MODE = Field.create((String)"schema.refresh.mode").withDisplayName("Schema refresh mode").withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)0)).withEnum(SchemaRefreshMode.class, (Enum)SchemaRefreshMode.COLUMNS_DIFF).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Specify the conditions that trigger a refresh of the in-memory schema for a table. 'columns_diff' (the default) is the safest mode, ensuring the in-memory schema stays in-sync with the database table's schema at all times. 'columns_diff_exclude_unchanged_toast' instructs the connector to refresh the in-memory schema cache if there is a discrepancy between it and the schema derived from the incoming message, unless unchanged TOASTable data fully accounts for the discrepancy. This setting can improve connector performance significantly if there are frequently-updated tables that have TOASTed data that are rarely part of these updates. However, it is possible for the in-memory schema to become outdated if TOASTable columns are dropped from the table.");
    public static final Field XMIN_FETCH_INTERVAL = Field.create((String)"xmin.fetch.interval.ms").withDisplayName("Xmin fetch interval (ms)").withType(ConfigDef.Type.LONG).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_REPLICATION, (int)7)).withWidth(ConfigDef.Width.SHORT).withDefault(0L).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Specify how often (in ms) the xmin will be fetched from the replication slot. This xmin value is exposed by the slot which gives a lower bound of where a new replication slot could start from. The lower the value, the more likely this value is to be the current 'true' value, but the bigger the performance cost. The bigger the value, the less likely this value is to be the current 'true' value, but the lower the performance penalty. The default is set to 0 ms, which disables tracking xmin.").withValidation(new Field.Validator[]{Field::isNonNegativeLong});
    public static final Field UNAVAILABLE_VALUE_PLACEHOLDER = RelationalDatabaseConnectorConfig.UNAVAILABLE_VALUE_PLACEHOLDER.withDescription("Specify the constant that will be provided by Debezium to indicate that the original value is a toasted value not provided by the database. If starts with 'hex:' prefix it is expected that the rest of the string represents hexadecimal encoded octets.");
    public static final Field MONEY_FRACTION_DIGITS = Field.create((String)"money.fraction.digits").withDisplayName("Money fraction digits").withType(ConfigDef.Type.SHORT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)1)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDefault(2).withDescription("Number of fractional digits when money type is converted to 'precise' decimal number.");
    public static final Field SHOULD_FLUSH_LSN_IN_SOURCE_DB = Field.create((String)"flush.lsn.source").withDisplayName("Boolean to determine if Debezium should flush LSN in the source database").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)99)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Boolean to determine if Debezium should flush LSN in the source postgres database. If set to false, user will have to flush the LSN manually outside Debezium.").withDefault(Boolean.TRUE.booleanValue()).withValidation(new Field.Validator[]{Field::isBoolean, PostgresConnectorConfig::validateFlushLsnSource});
    public static final Field SOURCE_INFO_STRUCT_MAKER = CommonConnectorConfig.SOURCE_INFO_STRUCT_MAKER.withDefault(PostgresSourceInfoStructMaker.class.getName());
    private final LogicalDecodingMessageFilter logicalDecodingMessageFilter;
    private final HStoreHandlingMode hStoreHandlingMode;
    private final IntervalHandlingMode intervalHandlingMode;
    private final SchemaRefreshMode schemaRefreshMode;
    private final boolean flushLsnOnSource;
    private final ReplicaIdentityMapper replicaIdentityMapper;
    private final SnapshotMode snapshotMode;
    private final SnapshotLockingMode snapshotLockingMode;
    private static final ConfigDefinition CONFIG_DEFINITION = RelationalDatabaseConnectorConfig.CONFIG_DEFINITION.edit().name("Postgres").excluding(new Field[]{CommonConnectorConfig.SKIPPED_OPERATIONS}).type(new Field[]{HOSTNAME, PORT, USER, PASSWORD, DATABASE_NAME, QUERY_TIMEOUT_MS, PLUGIN_NAME, SLOT_NAME, PUBLICATION_NAME, PUBLICATION_AUTOCREATE_MODE, REPLICA_IDENTITY_AUTOSET_VALUES, DROP_SLOT_ON_STOP, STREAM_PARAMS, ON_CONNECT_STATEMENTS, SSL_MODE, SSL_CLIENT_CERT, SSL_CLIENT_KEY_PASSWORD, SSL_ROOT_CERT, SSL_CLIENT_KEY, MAX_RETRIES, RETRY_DELAY_MS, SSL_SOCKET_FACTORY, STATUS_UPDATE_INTERVAL_MS, TCP_KEEPALIVE, XMIN_FETCH_INTERVAL, SKIPPED_OPERATIONS, SHOULD_FLUSH_LSN_IN_SOURCE_DB}).events(new Field[]{INCLUDE_UNKNOWN_DATATYPES, SOURCE_INFO_STRUCT_MAKER}).connector(new Field[]{SNAPSHOT_MODE, SNAPSHOT_QUERY_MODE, SNAPSHOT_QUERY_MODE_CUSTOM_NAME, SNAPSHOT_LOCKING_MODE_CUSTOM_NAME, SNAPSHOT_LOCKING_MODE, HSTORE_HANDLING_MODE, BINARY_HANDLING_MODE, SCHEMA_NAME_ADJUSTMENT_MODE, INTERVAL_HANDLING_MODE, SCHEMA_REFRESH_MODE, INCREMENTAL_SNAPSHOT_CHUNK_SIZE, UNAVAILABLE_VALUE_PLACEHOLDER, LOGICAL_DECODING_MESSAGE_PREFIX_INCLUDE_LIST, LOGICAL_DECODING_MESSAGE_PREFIX_EXCLUDE_LIST}).excluding(new Field[]{INCLUDE_SCHEMA_CHANGES}).create();
    public static Field.Set ALL_FIELDS = Field.setOf((Iterable)CONFIG_DEFINITION.all());

    public PostgresConnectorConfig(Configuration config) {
        super(config, (Tables.TableFilter)new SystemTablesPredicate(), x -> x.schema() + "." + x.table(), 10240, ColumnFilterMode.SCHEMA, false);
        this.logicalDecodingMessageFilter = new LogicalDecodingMessageFilter(config.getString(LOGICAL_DECODING_MESSAGE_PREFIX_INCLUDE_LIST), config.getString(LOGICAL_DECODING_MESSAGE_PREFIX_EXCLUDE_LIST));
        String hstoreHandlingModeStr = config.getString(HSTORE_HANDLING_MODE);
        this.hStoreHandlingMode = HStoreHandlingMode.parse(hstoreHandlingModeStr);
        this.intervalHandlingMode = IntervalHandlingMode.parse(config.getString(INTERVAL_HANDLING_MODE));
        this.schemaRefreshMode = SchemaRefreshMode.parse(config.getString(SCHEMA_REFRESH_MODE));
        this.flushLsnOnSource = config.getBoolean(SHOULD_FLUSH_LSN_IN_SOURCE_DB);
        String replicaIdentityMapping = config.getString(REPLICA_IDENTITY_AUTOSET_VALUES);
        this.replicaIdentityMapper = replicaIdentityMapping != null ? new ReplicaIdentityMapper(replicaIdentityMapping) : null;
        this.snapshotMode = SnapshotMode.parse(config.getString(SNAPSHOT_MODE), SNAPSHOT_MODE.defaultValueAsString());
        this.snapshotLockingMode = SnapshotLockingMode.parse(config.getString(SNAPSHOT_LOCKING_MODE), SNAPSHOT_LOCKING_MODE.defaultValueAsString());
    }

    protected String hostname() {
        return this.getConfig().getString(HOSTNAME);
    }

    protected int port() {
        return this.getConfig().getInteger(PORT);
    }

    public String databaseName() {
        return this.getConfig().getString(DATABASE_NAME);
    }

    public LogicalDecoder plugin() {
        return LogicalDecoder.parse(this.getConfig().getString(PLUGIN_NAME));
    }

    public String slotName() {
        return this.getConfig().getString(SLOT_NAME);
    }

    protected boolean dropSlotOnStop() {
        if (this.getConfig().hasKey(DROP_SLOT_ON_STOP.name())) {
            return this.getConfig().getBoolean(DROP_SLOT_ON_STOP);
        }
        return this.getConfig().getBoolean(DROP_SLOT_ON_STOP);
    }

    public boolean slotSeekToKnownOffsetOnStart() {
        return this.getConfig().getBoolean(SLOT_SEEK_TO_KNOWN_OFFSET);
    }

    public String publicationName() {
        return this.getConfig().getString(PUBLICATION_NAME);
    }

    protected AutoCreateMode publicationAutocreateMode() {
        return AutoCreateMode.parse(this.getConfig().getString(PUBLICATION_AUTOCREATE_MODE));
    }

    protected String streamParams() {
        return this.getConfig().getString(STREAM_PARAMS);
    }

    public int maxRetries() {
        return this.getConfig().getInteger(MAX_RETRIES);
    }

    public Duration retryDelay() {
        return Duration.ofMillis(this.getConfig().getInteger(RETRY_DELAY_MS));
    }

    protected Duration statusUpdateInterval() {
        return Duration.ofMillis(this.getConfig().getLong(STATUS_UPDATE_INTERVAL_MS));
    }

    public LogicalDecodingMessageFilter getMessageFilter() {
        return this.logicalDecodingMessageFilter;
    }

    protected HStoreHandlingMode hStoreHandlingMode() {
        return this.hStoreHandlingMode;
    }

    protected IntervalHandlingMode intervalHandlingMode() {
        return this.intervalHandlingMode;
    }

    protected boolean includeUnknownDatatypes() {
        return this.getConfig().getBoolean(INCLUDE_UNKNOWN_DATATYPES);
    }

    public Map<String, ConfigValue> validate() {
        return this.getConfig().validate(ALL_FIELDS);
    }

    protected boolean skipRefreshSchemaOnMissingToastableData() {
        return SchemaRefreshMode.COLUMNS_DIFF_EXCLUDE_UNCHANGED_TOAST == this.schemaRefreshMode;
    }

    protected Duration xminFetchInterval() {
        return Duration.ofMillis(this.getConfig().getLong(XMIN_FETCH_INTERVAL));
    }

    public boolean isFlushLsnOnSource() {
        return this.flushLsnOnSource;
    }

    public byte[] getUnavailableValuePlaceholder() {
        String placeholder = this.getConfig().getString(UNAVAILABLE_VALUE_PLACEHOLDER);
        if (placeholder.startsWith("hex:")) {
            return Strings.hexStringToByteArray((String)placeholder.substring(4));
        }
        return placeholder.getBytes();
    }

    public Optional<ReplicaIdentityMapper> replicaIdentityMapper() {
        return Optional.ofNullable(this.replicaIdentityMapper);
    }

    public SnapshotMode getSnapshotMode() {
        return this.snapshotMode;
    }

    public Optional<SnapshotLockingMode> getSnapshotLockingMode() {
        return Optional.of(this.snapshotLockingMode);
    }

    protected int moneyFractionDigits() {
        return this.getConfig().getInteger(MONEY_FRACTION_DIGITS);
    }

    protected SourceInfoStructMaker<? extends AbstractSourceInfo> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
        return this.getSourceInfoStructMaker(SOURCE_INFO_STRUCT_MAKER, Module.name(), Module.version(), (CommonConnectorConfig)this);
    }

    public static ConfigDef configDef() {
        return CONFIG_DEFINITION.configDef();
    }

    private static int validateReplicationSlotName(Configuration config, Field field, Field.ValidationOutput problems) {
        String name = config.getString(field);
        int errors = 0;
        if (name != null && !name.matches("[a-z0-9_]{1,63}")) {
            problems.accept(field, (Object)name, "Valid replication slot name must contain only digits, lowercase characters and underscores with length <= 63");
            ++errors;
        }
        return errors;
    }

    private static int validateLogicalDecodingMessageExcludeList(Configuration config, Field field, Field.ValidationOutput problems) {
        String includeList = config.getString(LOGICAL_DECODING_MESSAGE_PREFIX_INCLUDE_LIST);
        String excludeList = config.getString(LOGICAL_DECODING_MESSAGE_PREFIX_EXCLUDE_LIST);
        if (includeList != null && excludeList != null) {
            problems.accept(LOGICAL_DECODING_MESSAGE_PREFIX_EXCLUDE_LIST, (Object)excludeList, "\"logical_decoding_message.prefix.include.list\" is already specified");
            return 1;
        }
        return 0;
    }

    private static int validateFlushLsnSource(Configuration config, Field field, Field.ValidationOutput problems) {
        if (config.getString(SHOULD_FLUSH_LSN_IN_SOURCE_DB, "true").equalsIgnoreCase("false")) {
            LOGGER.warn("Property '" + SHOULD_FLUSH_LSN_IN_SOURCE_DB.name() + "' is set to 'false', the LSN will not be flushed to the database source and WAL logs will not be cleared. User is expected to handle this outside Debezium.");
        }
        return 0;
    }

    protected static int validateReplicaAutoSetField(Configuration config, Field field, Field.ValidationOutput problems) {
        String replica_autoset_values = config.getString(REPLICA_IDENTITY_AUTOSET_VALUES);
        int problemCount = 0;
        if (replica_autoset_values != null) {
            if (replica_autoset_values.isEmpty()) {
                problems.accept(REPLICA_IDENTITY_AUTOSET_VALUES, (Object)"", "Must not be empty");
            }
            for (String substring : ReplicaIdentityMapper.PATTERN_SPLIT.split(replica_autoset_values)) {
                if (ReplicaIdentityMapper.REPLICA_AUTO_SET_PATTERN.asPredicate().test(substring)) continue;
                problems.accept(REPLICA_IDENTITY_AUTOSET_VALUES, (Object)substring, substring + " has an invalid format (expecting '" + ReplicaIdentityMapper.REPLICA_AUTO_SET_PATTERN.pattern() + "')");
                ++problemCount;
            }
        }
        return problemCount;
    }

    public String getContextName() {
        return Module.contextName();
    }

    public String getConnectorName() {
        return Module.name();
    }

    private static class SystemTablesPredicate
    implements Tables.TableFilter {
        protected static final List<String> SYSTEM_SCHEMAS = Arrays.asList("pg_catalog", "information_schema");
        protected static final List<String> SYSTEM_TABLES = List.of("spatial_ref_sys");
        protected static final String TEMP_TABLE_SCHEMA_PREFIX = "pg_temp";

        private SystemTablesPredicate() {
        }

        public boolean isIncluded(TableId t) {
            return t.schema() != null && !SYSTEM_SCHEMAS.contains(t.schema().toLowerCase()) && t.table() != null && !SYSTEM_TABLES.contains(t.table().toLowerCase()) && !t.schema().startsWith(TEMP_TABLE_SCHEMA_PREFIX);
        }
    }

    public static enum HStoreHandlingMode implements EnumeratedValue
    {
        JSON("json"),
        MAP("map");

        private final String value;

        private HStoreHandlingMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static HStoreHandlingMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (HStoreHandlingMode option : HStoreHandlingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static HStoreHandlingMode parse(String value, String defaultValue) {
            HStoreHandlingMode mode = HStoreHandlingMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = HStoreHandlingMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum IntervalHandlingMode implements EnumeratedValue
    {
        NUMERIC("numeric"),
        STRING("string");

        private final String value;

        private IntervalHandlingMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static IntervalHandlingMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (IntervalHandlingMode option : IntervalHandlingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static IntervalHandlingMode parse(String value, String defaultValue) {
            IntervalHandlingMode mode = IntervalHandlingMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = IntervalHandlingMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum SchemaRefreshMode implements EnumeratedValue
    {
        COLUMNS_DIFF("columns_diff"),
        COLUMNS_DIFF_EXCLUDE_UNCHANGED_TOAST("columns_diff_exclude_unchanged_toast");

        private final String value;

        private SchemaRefreshMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SchemaRefreshMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SchemaRefreshMode option : SchemaRefreshMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }
    }

    public static enum SnapshotMode implements EnumeratedValue
    {
        ALWAYS("always"),
        INITIAL("initial"),
        NEVER("never"),
        NO_DATA("no_data"),
        INITIAL_ONLY("initial_only"),
        WHEN_NEEDED("when_needed"),
        CONFIGURATION_BASED("configuration_based"),
        CUSTOM("custom");

        private final String value;

        private SnapshotMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SnapshotMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotMode option : SnapshotMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotMode parse(String value, String defaultValue) {
            SnapshotMode mode = SnapshotMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum SnapshotLockingMode implements EnumeratedValue
    {
        SHARED("shared"),
        NONE("none"),
        CUSTOM("custom");

        private final String value;

        private SnapshotLockingMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SnapshotLockingMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotLockingMode option : SnapshotLockingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotLockingMode parse(String value, String defaultValue) {
            SnapshotLockingMode mode = SnapshotLockingMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotLockingMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum LogicalDecoder implements EnumeratedValue
    {
        PGOUTPUT("pgoutput"){

            @Override
            public MessageDecoder messageDecoder(MessageDecoderContext config, PostgresConnection connection) {
                return new PgOutputMessageDecoder(config, connection);
            }

            @Override
            public String getPostgresPluginName() {
                return this.getValue();
            }

            @Override
            public boolean supportsTruncate() {
                return true;
            }

            @Override
            public boolean supportsLogicalDecodingMessage() {
                return true;
            }
        }
        ,
        DECODERBUFS("decoderbufs"){

            @Override
            public MessageDecoder messageDecoder(MessageDecoderContext config, PostgresConnection connection) {
                return new PgProtoMessageDecoder();
            }

            @Override
            public String getPostgresPluginName() {
                return this.getValue();
            }

            @Override
            public boolean supportsTruncate() {
                return false;
            }

            @Override
            public boolean supportsLogicalDecodingMessage() {
                return false;
            }
        };

        private final String decoderName;

        private LogicalDecoder(String decoderName) {
            this.decoderName = decoderName;
        }

        public abstract MessageDecoder messageDecoder(MessageDecoderContext var1, PostgresConnection var2);

        public static LogicalDecoder parse(String s) {
            return LogicalDecoder.valueOf(s.trim().toUpperCase());
        }

        public String getValue() {
            return this.decoderName;
        }

        public abstract String getPostgresPluginName();

        public abstract boolean supportsTruncate();

        public abstract boolean supportsLogicalDecodingMessage();
    }

    public static enum AutoCreateMode implements EnumeratedValue
    {
        DISABLED("disabled"),
        ALL_TABLES("all_tables"),
        FILTERED("filtered");

        private final String value;

        private AutoCreateMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static AutoCreateMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (AutoCreateMode option : AutoCreateMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static AutoCreateMode parse(String value, String defaultValue) {
            AutoCreateMode mode = AutoCreateMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = AutoCreateMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum SecureConnectionMode implements EnumeratedValue
    {
        DISABLED("disable"),
        ALLOW("allow"),
        PREFER("prefer"),
        REQUIRED("require"),
        VERIFY_CA("verify-ca"),
        VERIFY_FULL("verify-full");

        private final String value;

        private SecureConnectionMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SecureConnectionMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SecureConnectionMode option : SecureConnectionMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SecureConnectionMode parse(String value, String defaultValue) {
            SecureConnectionMode mode = SecureConnectionMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SecureConnectionMode.parse(defaultValue);
            }
            return mode;
        }
    }
}

