/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection;

import io.debezium.connector.postgresql.connection.Lsn;
import io.debezium.connector.postgresql.spi.SlotState;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class ServerInfo {
    private String server;
    private String username;
    private String database;
    private Map<String, String> permissionsByRoleName = new HashMap<String, String>();

    protected ServerInfo() {
    }

    protected ServerInfo withServer(String server) {
        this.server = server;
        return this;
    }

    protected ServerInfo withUsername(String username) {
        this.username = username;
        return this;
    }

    protected ServerInfo withDatabase(String database) {
        this.database = database;
        return this;
    }

    protected ServerInfo addRole(String roleName, String permissions) {
        this.permissionsByRoleName.put(roleName, permissions);
        return this;
    }

    public String server() {
        return this.server;
    }

    public String username() {
        return this.username;
    }

    public String database() {
        return this.database;
    }

    public Map<String, String> permissionsByRoleName() {
        return this.permissionsByRoleName;
    }

    public String toString() {
        String lineSeparator = System.lineSeparator();
        String roles = this.permissionsByRoleName.entrySet().stream().map(entry -> "\trole '" + (String)entry.getKey() + "' [" + (String)entry.getValue() + "]").collect(Collectors.joining(lineSeparator));
        return "user '" + this.username + "' connected to database '" + this.database + "' on " + this.server + " with roles:" + lineSeparator + roles;
    }

    protected static class ReplicationSlot {
        protected static final ReplicationSlot INVALID = new ReplicationSlot(false, null, null, null);
        private boolean active;
        private Lsn latestFlushedLsn;
        private Lsn restartLsn;
        private Long catalogXmin;

        protected ReplicationSlot(boolean active, Lsn latestFlushedLsn, Lsn restartLsn, Long catalogXmin) {
            this.active = active;
            this.latestFlushedLsn = latestFlushedLsn;
            this.restartLsn = restartLsn;
            this.catalogXmin = catalogXmin;
        }

        protected boolean active() {
            return this.active;
        }

        protected Lsn latestFlushedLsn() {
            return this.latestFlushedLsn;
        }

        protected Lsn restartLsn() {
            return this.restartLsn;
        }

        protected Long catalogXmin() {
            return this.catalogXmin;
        }

        protected boolean hasValidFlushedLsn() {
            return this.latestFlushedLsn != null;
        }

        protected SlotState asSlotState() {
            return new SlotState(this.latestFlushedLsn, this.restartLsn, this.catalogXmin, this.active);
        }

        public String toString() {
            return "ReplicationSlot [active=" + this.active + ", latestFlushedLsn=" + this.latestFlushedLsn + ", catalogXmin=" + this.catalogXmin + "]";
        }
    }
}

