/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.connector.postgresql.PostgresStreamingChangeEventSource;
import io.debezium.connector.postgresql.PostgresType;
import io.debezium.connector.postgresql.connection.AbstractReplicationMessageColumn;

public class UnchangedToastedReplicationMessageColumn
extends AbstractReplicationMessageColumn {
    public static final Object UNCHANGED_TOAST_VALUE = new Object();
    public static final Object UNCHANGED_TEXT_ARRAY_TOAST_VALUE = new Object();
    public static final Object UNCHANGED_INT_ARRAY_TOAST_VALUE = new Object();
    public static final Object UNCHANGED_BIGINT_ARRAY_TOAST_VALUE = new Object();
    private Object unchangedToastValue;

    public UnchangedToastedReplicationMessageColumn(String columnName, PostgresType type, String typeWithModifiers, boolean optional) {
        super(columnName, type, typeWithModifiers, optional);
        this.setUnchangedToastValue(typeWithModifiers);
    }

    @Override
    public boolean isToastedColumn() {
        return true;
    }

    @Override
    public Object getValue(PostgresStreamingChangeEventSource.PgConnectionSupplier connection, boolean includeUnknownDatatypes) {
        return this.unchangedToastValue;
    }

    private void setUnchangedToastValue(String typeWithModifiers) {
        switch (typeWithModifiers) {
            case "text[]": 
            case "_text": 
            case "character varying[]": 
            case "_varchar": 
            case "json[]": 
            case "_json": 
            case "jsonb[]": 
            case "_jsonb": {
                this.unchangedToastValue = UNCHANGED_TEXT_ARRAY_TOAST_VALUE;
                break;
            }
            case "integer[]": 
            case "_int4": {
                this.unchangedToastValue = UNCHANGED_INT_ARRAY_TOAST_VALUE;
                break;
            }
            case "bigint[]": 
            case "_int8": {
                this.unchangedToastValue = UNCHANGED_BIGINT_ARRAY_TOAST_VALUE;
                break;
            }
            default: {
                this.unchangedToastValue = UNCHANGED_TOAST_VALUE;
            }
        }
    }
}

