/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.common.BaseSourceInfo;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.PostgresSnapshotChangeEventSource;
import io.debezium.connector.postgresql.SourceInfo;
import io.debezium.connector.postgresql.connection.Lsn;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.connector.postgresql.connection.ReplicationMessage;
import io.debezium.connector.postgresql.spi.OffsetState;
import io.debezium.pipeline.CommonOffsetContext;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotContext;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.TableId;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.time.Conversions;
import io.debezium.util.Clock;
import java.sql.SQLException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresOffsetContext
extends CommonOffsetContext<SourceInfo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresSnapshotChangeEventSource.class);
    public static final String LAST_COMPLETELY_PROCESSED_LSN_KEY = "lsn_proc";
    public static final String LAST_COMMIT_LSN_KEY = "lsn_commit";
    private final Schema sourceInfoSchema;
    private boolean lastSnapshotRecord;
    private Lsn lastCompletelyProcessedLsn;
    private Lsn lastCommitLsn;
    private Lsn streamingStoppingLsn = null;
    private final TransactionContext transactionContext;
    private final IncrementalSnapshotContext<TableId> incrementalSnapshotContext;

    private PostgresOffsetContext(PostgresConnectorConfig connectorConfig, Lsn lsn, Lsn lastCompletelyProcessedLsn, Lsn lastCommitLsn, Long txId, ReplicationMessage.Operation messageType, Instant time, boolean snapshot, boolean lastSnapshotRecord, TransactionContext transactionContext, IncrementalSnapshotContext<TableId> incrementalSnapshotContext) {
        super((BaseSourceInfo)new SourceInfo(connectorConfig));
        this.lastCompletelyProcessedLsn = lastCompletelyProcessedLsn;
        this.lastCommitLsn = lastCommitLsn;
        ((SourceInfo)this.sourceInfo).update(lsn, time, txId, ((SourceInfo)this.sourceInfo).xmin(), null, messageType);
        ((SourceInfo)this.sourceInfo).updateLastCommit(lastCommitLsn);
        this.sourceInfoSchema = ((SourceInfo)this.sourceInfo).schema();
        this.lastSnapshotRecord = lastSnapshotRecord;
        if (this.lastSnapshotRecord) {
            this.postSnapshotCompletion();
        } else {
            ((SourceInfo)this.sourceInfo).setSnapshot(snapshot ? SnapshotRecord.TRUE : SnapshotRecord.FALSE);
        }
        this.transactionContext = transactionContext;
        this.incrementalSnapshotContext = incrementalSnapshotContext;
    }

    public Map<String, ?> getOffset() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (((SourceInfo)this.sourceInfo).timestamp() != null) {
            result.put("ts_usec", Conversions.toEpochMicros((Instant)((SourceInfo)this.sourceInfo).timestamp()));
        }
        if (((SourceInfo)this.sourceInfo).txId() != null) {
            result.put("txId", ((SourceInfo)this.sourceInfo).txId());
        }
        if (((SourceInfo)this.sourceInfo).lsn() != null) {
            result.put("lsn", ((SourceInfo)this.sourceInfo).lsn().asLong());
        }
        if (((SourceInfo)this.sourceInfo).xmin() != null) {
            result.put("xmin", ((SourceInfo)this.sourceInfo).xmin());
        }
        if (((SourceInfo)this.sourceInfo).isSnapshot()) {
            result.put("snapshot", true);
            result.put("last_snapshot_record", this.lastSnapshotRecord);
        }
        if (this.lastCompletelyProcessedLsn != null) {
            result.put(LAST_COMPLETELY_PROCESSED_LSN_KEY, this.lastCompletelyProcessedLsn.asLong());
        }
        if (this.lastCommitLsn != null) {
            result.put(LAST_COMMIT_LSN_KEY, this.lastCommitLsn.asLong());
        }
        if (((SourceInfo)this.sourceInfo).messageType() != null) {
            result.put("messageType", ((SourceInfo)this.sourceInfo).messageType().toString());
        }
        return ((SourceInfo)this.sourceInfo).isSnapshot() ? result : this.incrementalSnapshotContext.store(this.transactionContext.store(result));
    }

    public Schema getSourceInfoSchema() {
        return this.sourceInfoSchema;
    }

    public boolean isSnapshotRunning() {
        return ((SourceInfo)this.sourceInfo).isSnapshot();
    }

    public void preSnapshotStart() {
        ((SourceInfo)this.sourceInfo).setSnapshot(SnapshotRecord.TRUE);
        this.lastSnapshotRecord = false;
    }

    public void preSnapshotCompletion() {
        this.lastSnapshotRecord = true;
    }

    public void updateWalPosition(Lsn lsn, Lsn lastCompletelyProcessedLsn, Instant commitTime, Long txId, Long xmin, TableId tableId, ReplicationMessage.Operation messageType) {
        this.lastCompletelyProcessedLsn = lastCompletelyProcessedLsn;
        ((SourceInfo)this.sourceInfo).update(lsn, commitTime, txId, xmin, tableId, messageType);
    }

    public void updateWalPosition(Lsn lsn, Lsn lastCompletelyProcessedLsn, Instant commitTime, Long txId, Long xmin, ReplicationMessage.Operation messageType) {
        this.updateWalPosition(lsn, lastCompletelyProcessedLsn, commitTime, txId, xmin, null, messageType);
    }

    public void updateCommitPosition(Lsn lsn, Lsn lastCompletelyProcessedLsn) {
        this.lastCompletelyProcessedLsn = lastCompletelyProcessedLsn;
        this.lastCommitLsn = lsn;
        ((SourceInfo)this.sourceInfo).updateLastCommit(lsn);
    }

    boolean hasLastKnownPosition() {
        return ((SourceInfo)this.sourceInfo).lsn() != null;
    }

    boolean hasCompletelyProcessedPosition() {
        return this.lastCompletelyProcessedLsn != null;
    }

    Lsn lsn() {
        return ((SourceInfo)this.sourceInfo).lsn();
    }

    Lsn lastCompletelyProcessedLsn() {
        return this.lastCompletelyProcessedLsn;
    }

    Lsn lastCommitLsn() {
        return this.lastCommitLsn;
    }

    ReplicationMessage.Operation lastProcessedMessageType() {
        return ((SourceInfo)this.sourceInfo).messageType();
    }

    Lsn getStreamingStoppingLsn() {
        return this.streamingStoppingLsn;
    }

    public void setStreamingStoppingLsn(Lsn streamingStoppingLsn) {
        this.streamingStoppingLsn = streamingStoppingLsn;
    }

    Long xmin() {
        return ((SourceInfo)this.sourceInfo).xmin();
    }

    public String toString() {
        return "PostgresOffsetContext [sourceInfoSchema=" + this.sourceInfoSchema + ", sourceInfo=" + this.sourceInfo + ", lastSnapshotRecord=" + this.lastSnapshotRecord + ", lastCompletelyProcessedLsn=" + this.lastCompletelyProcessedLsn + ", lastCommitLsn=" + this.lastCommitLsn + ", streamingStoppingLsn=" + this.streamingStoppingLsn + ", transactionContext=" + this.transactionContext + ", incrementalSnapshotContext=" + this.incrementalSnapshotContext + "]";
    }

    public static PostgresOffsetContext initialContext(PostgresConnectorConfig connectorConfig, PostgresConnection jdbcConnection, Clock clock) {
        return PostgresOffsetContext.initialContext(connectorConfig, jdbcConnection, clock, null, null);
    }

    public static PostgresOffsetContext initialContext(PostgresConnectorConfig connectorConfig, PostgresConnection jdbcConnection, Clock clock, Lsn lastCommitLsn, Lsn lastCompletelyProcessedLsn) {
        try {
            LOGGER.info("Creating initial offset context");
            Lsn lsn = Lsn.valueOf(jdbcConnection.currentXLogLocation());
            long txId = jdbcConnection.currentTransactionId();
            LOGGER.info("Read xlogStart at '{}' from transaction '{}'", (Object)lsn, (Object)txId);
            return new PostgresOffsetContext(connectorConfig, lsn, lastCompletelyProcessedLsn, lastCommitLsn, txId, null, clock.currentTimeAsInstant(), false, false, new TransactionContext(), (IncrementalSnapshotContext<TableId>)new SignalBasedIncrementalSnapshotContext(false));
        }
        catch (SQLException e) {
            throw new ConnectException("Database processing error", (Throwable)e);
        }
    }

    public OffsetState asOffsetState() {
        return new OffsetState(((SourceInfo)this.sourceInfo).lsn(), ((SourceInfo)this.sourceInfo).txId(), ((SourceInfo)this.sourceInfo).xmin(), ((SourceInfo)this.sourceInfo).timestamp(), ((SourceInfo)this.sourceInfo).isSnapshot());
    }

    public void event(DataCollectionId tableId, Instant instant) {
        ((SourceInfo)this.sourceInfo).update(instant, (TableId)tableId);
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public IncrementalSnapshotContext<?> getIncrementalSnapshotContext() {
        return this.incrementalSnapshotContext;
    }

    public static class Loader
    implements OffsetContext.Loader<PostgresOffsetContext> {
        private final PostgresConnectorConfig connectorConfig;

        public Loader(PostgresConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        private Long readOptionalLong(Map<String, ?> offset, String key) {
            Object obj = offset.get(key);
            return obj == null ? null : Long.valueOf(((Number)obj).longValue());
        }

        public PostgresOffsetContext load(Map<String, ?> offset) {
            Lsn lsn = Lsn.valueOf(this.readOptionalLong(offset, "lsn"));
            Lsn lastCompletelyProcessedLsn = Lsn.valueOf(this.readOptionalLong(offset, PostgresOffsetContext.LAST_COMPLETELY_PROCESSED_LSN_KEY));
            Lsn lastCommitLsn = Lsn.valueOf(this.readOptionalLong(offset, PostgresOffsetContext.LAST_COMMIT_LSN_KEY));
            if (lastCommitLsn == null) {
                lastCommitLsn = lastCompletelyProcessedLsn;
            }
            Long txId = this.readOptionalLong(offset, "txId");
            String msgType = offset.getOrDefault("messageType", null);
            ReplicationMessage.Operation messageType = msgType == null ? null : ReplicationMessage.Operation.valueOf(msgType);
            Instant useconds = Conversions.toInstantFromMicros((long)((Long)offset.get("ts_usec")));
            boolean snapshot = offset.getOrDefault("snapshot", Boolean.FALSE);
            boolean lastSnapshotRecord = offset.getOrDefault("last_snapshot_record", Boolean.FALSE);
            return new PostgresOffsetContext(this.connectorConfig, lsn, lastCompletelyProcessedLsn, lastCommitLsn, txId, messageType, useconds, snapshot, lastSnapshotRecord, TransactionContext.load(offset), (IncrementalSnapshotContext<TableId>)SignalBasedIncrementalSnapshotContext.load(offset, (boolean)false));
        }
    }
}

