/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.connector.postgresql.Module;
import io.debezium.connector.postgresql.PostgresChangeEventSourceCoordinator;
import io.debezium.connector.postgresql.PostgresChangeEventSourceFactory;
import io.debezium.connector.postgresql.PostgresChangeRecordEmitter;
import io.debezium.connector.postgresql.PostgresConnector;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.PostgresErrorHandler;
import io.debezium.connector.postgresql.PostgresEventMetadataProvider;
import io.debezium.connector.postgresql.PostgresOffsetContext;
import io.debezium.connector.postgresql.PostgresPartition;
import io.debezium.connector.postgresql.PostgresSchema;
import io.debezium.connector.postgresql.PostgresTaskContext;
import io.debezium.connector.postgresql.PostgresTopicSelector;
import io.debezium.connector.postgresql.PostgresValueConverter;
import io.debezium.connector.postgresql.TypeRegistry;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.connector.postgresql.connection.ReplicationConnection;
import io.debezium.connector.postgresql.spi.SlotCreationResult;
import io.debezium.connector.postgresql.spi.SlotState;
import io.debezium.connector.postgresql.spi.Snapshotter;
import io.debezium.heartbeat.DatabaseHeartbeatImpl;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.metrics.DefaultChangeEventSourceMetricsFactory;
import io.debezium.pipeline.metrics.spi.ChangeEventSourceMetricsFactory;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionFilters;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.TopicSelector;
import io.debezium.util.Clock;
import io.debezium.util.LoggingContext;
import io.debezium.util.Metronome;
import io.debezium.util.SchemaNameAdjuster;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.RetriableException;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresConnectorTask
extends BaseSourceTask<PostgresPartition, PostgresOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresConnectorTask.class);
    private static final String CONTEXT_NAME = "postgres-connector-task";
    private volatile PostgresTaskContext taskContext;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile PostgresConnection jdbcConnection;
    private volatile PostgresConnection heartbeatConnection;
    private volatile ReplicationConnection replicationConnection = null;
    private volatile PostgresSchema schema;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeEventSourceCoordinator<PostgresPartition, PostgresOffsetContext> start(Configuration config) {
        PostgresConnectorConfig connectorConfig = new PostgresConnectorConfig(config);
        TopicSelector<TableId> topicSelector = PostgresTopicSelector.create(connectorConfig);
        Snapshotter snapshotter = connectorConfig.getSnapshotter();
        SchemaNameAdjuster schemaNameAdjuster = SchemaNameAdjuster.create();
        if (snapshotter == null) {
            throw new ConnectException("Unable to load snapshotter, if using custom snapshot mode, double check your settings");
        }
        this.heartbeatConnection = new PostgresConnection(connectorConfig.getJdbcConfig());
        Charset databaseCharset = this.heartbeatConnection.getDatabaseCharset();
        PostgresConnection.PostgresValueConverterBuilder valueConverterBuilder = typeRegistry -> PostgresValueConverter.of(connectorConfig, databaseCharset, typeRegistry);
        this.jdbcConnection = new PostgresConnection(connectorConfig.getJdbcConfig(), valueConverterBuilder);
        try {
            this.jdbcConnection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new DebeziumException((Throwable)e);
        }
        TypeRegistry typeRegistry2 = this.jdbcConnection.getTypeRegistry();
        this.schema = new PostgresSchema(connectorConfig, typeRegistry2, topicSelector, valueConverterBuilder.build(typeRegistry2));
        this.taskContext = new PostgresTaskContext(connectorConfig, this.schema, topicSelector);
        Offsets previousOffsets = this.getPreviousOffsets(new PostgresPartition.Provider(connectorConfig), new PostgresOffsetContext.Loader(connectorConfig));
        Clock clock = Clock.system();
        PostgresOffsetContext previousOffset = (PostgresOffsetContext)previousOffsets.getTheOnlyOffset();
        LoggingContext.PreviousContext previousContext = this.taskContext.configureLoggingContext(CONTEXT_NAME);
        try {
            SlotState slotInfo = null;
            try {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(this.jdbcConnection.serverInfo().toString());
                }
                slotInfo = this.jdbcConnection.getReplicationSlotState(connectorConfig.slotName(), connectorConfig.plugin().getPostgresPluginName());
            }
            catch (SQLException e) {
                LOGGER.warn("unable to load info of replication slot, Debezium will try to create the slot");
            }
            if (previousOffset == null) {
                LOGGER.info("No previous offset found");
                snapshotter.init(connectorConfig, null, slotInfo);
            } else {
                LOGGER.info("Found previous offset {}", (Object)previousOffset);
                snapshotter.init(connectorConfig, previousOffset.asOffsetState(), slotInfo);
            }
            SlotCreationResult slotCreatedInfo = null;
            if (snapshotter.shouldStream()) {
                boolean doSnapshot = snapshotter.shouldSnapshot();
                this.replicationConnection = this.createReplicationConnection(this.taskContext, doSnapshot, connectorConfig.maxRetries(), connectorConfig.retryDelay());
                if (slotInfo == null) {
                    try {
                        slotCreatedInfo = this.replicationConnection.createReplicationSlot().orElse(null);
                    }
                    catch (SQLException ex) {
                        String message = "Creation of replication slot failed";
                        if (ex.getMessage().contains("already exists")) {
                            message = message + "; when setting up multiple connectors for the same database host, please make sure to use a distinct replication slot name for each.";
                        }
                        throw new DebeziumException(message, (Throwable)ex);
                    }
                } else {
                    slotCreatedInfo = null;
                }
            }
            try {
                this.jdbcConnection.commit();
            }
            catch (SQLException e) {
                throw new DebeziumException((Throwable)e);
            }
            this.queue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).maxQueueSizeInBytes(connectorConfig.getMaxQueueSizeInBytes()).loggingContextSupplier(() -> this.taskContext.configureLoggingContext(CONTEXT_NAME)).build();
            PostgresErrorHandler errorHandler = new PostgresErrorHandler(connectorConfig.getLogicalName(), this.queue);
            PostgresEventMetadataProvider metadataProvider = new PostgresEventMetadataProvider();
            Configuration configuration = connectorConfig.getConfig();
            Heartbeat heartbeat = Heartbeat.create((Duration)configuration.getDuration(Heartbeat.HEARTBEAT_INTERVAL, (TemporalUnit)ChronoUnit.MILLIS), (String)configuration.getString(DatabaseHeartbeatImpl.HEARTBEAT_ACTION_QUERY), (String)topicSelector.getHeartbeatTopic(), (String)connectorConfig.getLogicalName(), (JdbcConnection)this.heartbeatConnection, exception -> {
                String sqlErrorId;
                switch (sqlErrorId = exception.getSQLState()) {
                    case "57P01": {
                        throw new DebeziumException("Could not execute heartbeat action (Error: " + sqlErrorId + ")", (Throwable)exception);
                    }
                    case "57P03": {
                        throw new RetriableException("Could not execute heartbeat action (Error: " + sqlErrorId + ")", (Throwable)exception);
                    }
                }
            });
            EventDispatcher dispatcher = new EventDispatcher((CommonConnectorConfig)connectorConfig, topicSelector, (DatabaseSchema)this.schema, this.queue, (DataCollectionFilters.DataCollectionFilter)connectorConfig.getTableFilters().dataCollectionFilter(), DataChangeEvent::new, PostgresChangeRecordEmitter::updateSchema, (EventMetadataProvider)metadataProvider, heartbeat, schemaNameAdjuster, (JdbcConnection)this.jdbcConnection);
            PostgresChangeEventSourceCoordinator coordinator = new PostgresChangeEventSourceCoordinator((Offsets<PostgresPartition, PostgresOffsetContext>)previousOffsets, errorHandler, (Class<? extends SourceConnector>)PostgresConnector.class, (CommonConnectorConfig)connectorConfig, new PostgresChangeEventSourceFactory(connectorConfig, snapshotter, this.jdbcConnection, errorHandler, (EventDispatcher<TableId>)dispatcher, clock, this.schema, this.taskContext, this.replicationConnection, slotCreatedInfo, slotInfo), (ChangeEventSourceMetricsFactory)new DefaultChangeEventSourceMetricsFactory(), (EventDispatcher<?>)dispatcher, (DatabaseSchema<?>)this.schema, snapshotter, slotInfo);
            coordinator.start(this.taskContext, (ChangeEventQueueMetrics)this.queue, metadataProvider);
            PostgresChangeEventSourceCoordinator postgresChangeEventSourceCoordinator = coordinator;
            return postgresChangeEventSourceCoordinator;
        }
        finally {
            previousContext.restore();
        }
    }

    public ReplicationConnection createReplicationConnection(PostgresTaskContext taskContext, boolean doSnapshot, int maxRetries, Duration retryDelay) throws ConnectException {
        Metronome metronome = Metronome.parker((Duration)retryDelay, (Clock)Clock.SYSTEM);
        short retryCount = 0;
        ReplicationConnection replicationConnection = null;
        while (retryCount <= maxRetries) {
            try {
                return taskContext.createReplicationConnection(doSnapshot);
            }
            catch (SQLException ex) {
                retryCount = (short)(retryCount + 1);
                if (retryCount > maxRetries) {
                    LOGGER.error("Too many errors connecting to server. All {} retries failed.", (Object)maxRetries);
                    throw new ConnectException((Throwable)ex);
                }
                LOGGER.warn("Error connecting to server; will attempt retry {} of {} after {} seconds. Exception message: {}", new Object[]{retryCount, maxRetries, retryDelay.getSeconds(), ex.getMessage()});
                try {
                    metronome.pause();
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Connection retry sleep interrupted by exception: " + e);
                    Thread.currentThread().interrupt();
                }
            }
        }
        return replicationConnection;
    }

    public List<SourceRecord> doPoll() throws InterruptedException {
        List records = this.queue.poll();
        List<SourceRecord> sourceRecords = records.stream().map(DataChangeEvent::getRecord).collect(Collectors.toList());
        return sourceRecords;
    }

    protected void doStop() {
        try {
            if (this.replicationConnection != null) {
                this.replicationConnection.close();
            }
        }
        catch (Exception e) {
            LOGGER.trace("Error while closing replication connection", (Throwable)e);
        }
        if (this.jdbcConnection != null) {
            this.jdbcConnection.close();
        }
        if (this.heartbeatConnection != null) {
            this.heartbeatConnection.close();
        }
        if (this.schema != null) {
            this.schema.close();
        }
    }

    public String version() {
        return Module.version();
    }

    protected Iterable<Field> getAllConfigurationFields() {
        return PostgresConnectorConfig.ALL_FIELDS;
    }

    public PostgresTaskContext getTaskContext() {
        return this.taskContext;
    }
}

