/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection;

import io.debezium.connector.postgresql.TypeRegistry;
import io.debezium.connector.postgresql.connection.Lsn;
import io.debezium.connector.postgresql.connection.MessageDecoder;
import io.debezium.connector.postgresql.connection.MessageDecoderConfig;
import io.debezium.connector.postgresql.connection.ReplicationStream;
import io.debezium.connector.postgresql.connection.WalPositionLocator;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageDecoder
implements MessageDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMessageDecoder.class);
    private final boolean filterBasedOnLsn;

    public AbstractMessageDecoder(MessageDecoderConfig config) {
        this.filterBasedOnLsn = !config.exportedSnapshot() || !config.doSnapshot();
    }

    @Override
    public void processMessage(ByteBuffer buffer, ReplicationStream.ReplicationMessageProcessor processor, TypeRegistry typeRegistry) throws SQLException, InterruptedException {
        if (buffer == null) {
            processor.process(null);
        } else {
            this.processNotEmptyMessage(buffer, processor, typeRegistry);
        }
    }

    protected abstract void processNotEmptyMessage(ByteBuffer var1, ReplicationStream.ReplicationMessageProcessor var2, TypeRegistry var3) throws SQLException, InterruptedException;

    @Override
    public boolean shouldMessageBeSkipped(ByteBuffer buffer, Lsn lastReceivedLsn, Lsn startLsn, WalPositionLocator walPosition) {
        if (walPosition.skipMessage(lastReceivedLsn)) {
            LOGGER.info("Streaming requested from LSN {}, received LSN {} identified as already processed", (Object)startLsn, (Object)lastReceivedLsn);
            return true;
        }
        return false;
    }
}

