/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.connector.postgresql.PostgresChangeRecordEmitter;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.PostgresOffsetContext;
import io.debezium.connector.postgresql.PostgresSchema;
import io.debezium.connector.postgresql.PostgresTaskContext;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.connector.postgresql.connection.ReplicationConnection;
import io.debezium.connector.postgresql.connection.ReplicationMessage;
import io.debezium.connector.postgresql.connection.ReplicationStream;
import io.debezium.connector.postgresql.spi.Snapshotter;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionId;
import io.debezium.util.Clock;
import io.debezium.util.DelayStrategy;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.connect.errors.ConnectException;
import org.postgresql.core.BaseConnection;
import org.postgresql.replication.LogSequenceNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresStreamingChangeEventSource
implements StreamingChangeEventSource {
    private static final int GROWING_WAL_WARNING_LOG_INTERVAL = 10000;
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresStreamingChangeEventSource.class);
    private static final int THROTTLE_NO_MESSAGE_BEFORE_PAUSE = 5;
    private final PostgresConnection connection;
    private final EventDispatcher<TableId> dispatcher;
    private final ErrorHandler errorHandler;
    private final Clock clock;
    private final PostgresSchema schema;
    private final PostgresOffsetContext offsetContext;
    private final PostgresConnectorConfig connectorConfig;
    private final PostgresTaskContext taskContext;
    private final ReplicationConnection replicationConnection;
    private final AtomicReference<ReplicationStream> replicationStream = new AtomicReference();
    private final Snapshotter snapshotter;
    private final DelayStrategy pauseNoMessage;
    private final boolean hasStartLsnStoredInContext;
    private long numberOfEventsSinceLastEventSentOrWalGrowingWarning = 0L;
    private Long lastCompletelyProcessedLsn;

    public PostgresStreamingChangeEventSource(PostgresConnectorConfig connectorConfig, Snapshotter snapshotter, PostgresOffsetContext offsetContext, PostgresConnection connection, EventDispatcher<TableId> dispatcher, ErrorHandler errorHandler, Clock clock, PostgresSchema schema, PostgresTaskContext taskContext, ReplicationConnection replicationConnection) {
        this.connectorConfig = connectorConfig;
        this.connection = connection;
        this.dispatcher = dispatcher;
        this.errorHandler = errorHandler;
        this.clock = clock;
        this.schema = schema;
        this.offsetContext = offsetContext != null ? offsetContext : PostgresOffsetContext.initialContext(connectorConfig, connection, clock);
        this.hasStartLsnStoredInContext = offsetContext != null;
        this.pauseNoMessage = DelayStrategy.constant((long)taskContext.getConfig().getPollInterval().toMillis());
        this.taskContext = taskContext;
        this.snapshotter = snapshotter;
        this.replicationConnection = replicationConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ChangeEventSource.ChangeEventSourceContext context) throws InterruptedException {
        ReplicationStream stream;
        if (!this.snapshotter.shouldStream()) {
            LOGGER.info("Streaming is not enabled in correct configuration");
            return;
        }
        try {
            if (this.hasStartLsnStoredInContext) {
                Long lsn;
                Long l = lsn = this.offsetContext.lastCompletelyProcessedLsn() != null ? this.offsetContext.lastCompletelyProcessedLsn() : this.offsetContext.lsn();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("retrieved latest position from stored offset '{}'", (Object)ReplicationConnection.format(lsn));
                }
                this.replicationStream.compareAndSet(null, this.replicationConnection.startStreaming(lsn));
            } else {
                LOGGER.info("no previous LSN found in Kafka, streaming from the latest xlogpos or flushed LSN...");
                this.replicationStream.compareAndSet(null, this.replicationConnection.startStreaming());
            }
            stream = this.replicationStream.get();
            stream.startKeepAlive(Executors.newSingleThreadExecutor());
            this.taskContext.refreshSchema(this.connection, true);
            this.lastCompletelyProcessedLsn = this.replicationStream.get().startLsn();
            int noMessageIterations = 0;
            while (context.isRunning()) {
                boolean receivedMessage = stream.readPending(message -> {
                    Long lsn = stream.lastReceivedLsn();
                    if (message.isLastEventForLsn()) {
                        this.lastCompletelyProcessedLsn = lsn;
                    }
                    if (message.isTransactionalMessage()) {
                        if (!this.connectorConfig.shouldProvideTransactionMetadata()) {
                            LOGGER.trace("Received transactional message {}", (Object)message);
                            if (message.getOperation() == ReplicationMessage.Operation.COMMIT) {
                                this.skipMessage(lsn);
                            }
                            return;
                        }
                        this.offsetContext.updateWalPosition(lsn, this.lastCompletelyProcessedLsn, message.getCommitTime(), message.getTransactionId(), null, this.taskContext.getSlotXmin(this.connection));
                        if (message.getOperation() == ReplicationMessage.Operation.BEGIN) {
                            this.dispatcher.dispatchTransactionStartedEvent(Long.toString(message.getTransactionId()), (OffsetContext)this.offsetContext);
                        } else if (message.getOperation() == ReplicationMessage.Operation.COMMIT) {
                            this.dispatcher.dispatchTransactionCommittedEvent((OffsetContext)this.offsetContext);
                        }
                        this.maybeWarnAboutGrowingWalBacklog(true);
                        return;
                    }
                    TableId tableId = null;
                    if (message.getOperation() != ReplicationMessage.Operation.NOOP) {
                        tableId = PostgresSchema.parse(message.getTable());
                        Objects.requireNonNull(tableId);
                    }
                    this.offsetContext.updateWalPosition(lsn, this.lastCompletelyProcessedLsn, message.getCommitTime(), message.getTransactionId(), tableId, this.taskContext.getSlotXmin(this.connection));
                    boolean dispatched = message.getOperation() == ReplicationMessage.Operation.NOOP ? false : this.dispatcher.dispatchDataChangeEvent((DataCollectionId)tableId, (ChangeRecordEmitter)new PostgresChangeRecordEmitter(this.offsetContext, this.clock, this.connectorConfig, this.schema, this.connection, message));
                    this.maybeWarnAboutGrowingWalBacklog(dispatched);
                });
                if (receivedMessage) {
                    noMessageIterations = 0;
                    continue;
                }
                if (this.offsetContext.hasCompletelyProcessedPosition()) {
                    this.dispatcher.dispatchHeartbeatEvent((OffsetContext)this.offsetContext);
                }
                if (++noMessageIterations < 5) continue;
                noMessageIterations = 0;
                this.pauseNoMessage.sleepWhen(true);
            }
        }
        catch (Throwable e) {
            this.errorHandler.setProducerThrowable(e);
        }
        finally {
            if (this.replicationConnection != null) {
                LOGGER.debug("stopping streaming...");
                stream = this.replicationStream.get();
                if (stream != null) {
                    stream.stopKeepAlive();
                }
                try {
                    this.replicationConnection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void skipMessage(Long lsn) throws SQLException, InterruptedException {
        this.lastCompletelyProcessedLsn = lsn;
        this.offsetContext.updateWalPosition(lsn, this.lastCompletelyProcessedLsn, null, null, null, this.taskContext.getSlotXmin(this.connection));
        this.maybeWarnAboutGrowingWalBacklog(false);
        this.dispatcher.dispatchHeartbeatEvent((OffsetContext)this.offsetContext);
    }

    private void maybeWarnAboutGrowingWalBacklog(boolean dispatched) {
        this.numberOfEventsSinceLastEventSentOrWalGrowingWarning = dispatched ? 0L : ++this.numberOfEventsSinceLastEventSentOrWalGrowingWarning;
        if (this.numberOfEventsSinceLastEventSentOrWalGrowingWarning > 10000L && !this.dispatcher.heartbeatsEnabled()) {
            LOGGER.warn("Received {} events which were all filtered out, so no offset could be committed. This prevents the replication slot from acknowledging the processed WAL offsets, causing a growing backlog of non-removeable WAL segments on the database server. Consider to either adjust your filter configuration or enable heartbeat events (via the {} option) to avoid this situation.", (Object)this.numberOfEventsSinceLastEventSentOrWalGrowingWarning, (Object)"heartbeat.interval.ms");
            this.numberOfEventsSinceLastEventSentOrWalGrowingWarning = 0L;
        }
    }

    public void commitOffset(Map<String, ?> offset) {
        try {
            ReplicationStream replicationStream = this.replicationStream.get();
            Long lsn = (Long)offset.get("lsn_proc");
            if (replicationStream != null && lsn != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Flushing LSN to server: {}", (Object)LogSequenceNumber.valueOf((long)lsn));
                }
                replicationStream.flushLsn(lsn);
            } else {
                LOGGER.debug("Streaming has already stopped, ignoring commit callback...");
            }
        }
        catch (SQLException e) {
            throw new ConnectException((Throwable)e);
        }
    }

    @FunctionalInterface
    public static interface PgConnectionSupplier {
        public BaseConnection get() throws SQLException;
    }
}

