/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.postgresql.Module;
import io.debezium.connector.postgresql.PostgresChangeEventSourceFactory;
import io.debezium.connector.postgresql.PostgresChangeRecordEmitter;
import io.debezium.connector.postgresql.PostgresConnector;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.PostgresErrorHandler;
import io.debezium.connector.postgresql.PostgresEventMetadataProvider;
import io.debezium.connector.postgresql.PostgresOffsetContext;
import io.debezium.connector.postgresql.PostgresSchema;
import io.debezium.connector.postgresql.PostgresTaskContext;
import io.debezium.connector.postgresql.PostgresTopicSelector;
import io.debezium.connector.postgresql.SourceInfo;
import io.debezium.connector.postgresql.TypeRegistry;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.connector.postgresql.connection.ReplicationConnection;
import io.debezium.connector.postgresql.spi.SlotCreationResult;
import io.debezium.connector.postgresql.spi.SlotState;
import io.debezium.connector.postgresql.spi.Snapshotter;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.metrics.DefaultChangeEventSourceMetricsFactory;
import io.debezium.pipeline.metrics.spi.ChangeEventSourceMetricsFactory;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionFilters;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.TopicSelector;
import io.debezium.util.Clock;
import io.debezium.util.LoggingContext;
import io.debezium.util.Metronome;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresConnectorTask
extends BaseSourceTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresConnectorTask.class);
    private static final String CONTEXT_NAME = "postgres-connector-task";
    private volatile PostgresTaskContext taskContext;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile PostgresConnection jdbcConnection;
    private volatile PostgresConnection heartbeatConnection;
    private volatile ErrorHandler errorHandler;
    private volatile PostgresSchema schema;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeEventSourceCoordinator start(Configuration config) {
        PostgresConnectorConfig connectorConfig = new PostgresConnectorConfig(config);
        TopicSelector<TableId> topicSelector = PostgresTopicSelector.create(connectorConfig);
        Snapshotter snapshotter = connectorConfig.getSnapshotter();
        if (snapshotter == null) {
            throw new ConnectException("Unable to load snapshotter, if using custom snapshot mode, double check your settings");
        }
        this.jdbcConnection = new PostgresConnection(connectorConfig.jdbcConfig());
        this.heartbeatConnection = new PostgresConnection(connectorConfig.jdbcConfig());
        TypeRegistry typeRegistry = this.jdbcConnection.getTypeRegistry();
        Charset databaseCharset = this.jdbcConnection.getDatabaseCharset();
        this.schema = new PostgresSchema(connectorConfig, typeRegistry, databaseCharset, topicSelector);
        this.taskContext = new PostgresTaskContext(connectorConfig, this.schema, topicSelector);
        PostgresOffsetContext previousOffset = (PostgresOffsetContext)this.getPreviousOffset(new PostgresOffsetContext.Loader(connectorConfig));
        Clock clock = Clock.system();
        SourceInfo sourceInfo = new SourceInfo(connectorConfig);
        LoggingContext.PreviousContext previousContext = this.taskContext.configureLoggingContext(CONTEXT_NAME);
        try {
            SlotState slotInfo = null;
            try (PostgresConnection connection = this.taskContext.createConnection();){
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(connection.serverInfo().toString());
                }
                slotInfo = connection.getReplicationSlotState(connectorConfig.slotName(), connectorConfig.plugin().getPostgresPluginName());
            }
            catch (SQLException e) {
                LOGGER.warn("unable to load info of replication slot, Debezium will try to create the slot");
            }
            if (previousOffset == null) {
                LOGGER.info("No previous offset found");
                snapshotter.init(connectorConfig, null, slotInfo);
            } else {
                LOGGER.info("Found previous offset {}", (Object)sourceInfo);
                snapshotter.init(connectorConfig, previousOffset.asOffsetState(), slotInfo);
            }
            ReplicationConnection replicationConnection = null;
            SlotCreationResult slotCreatedInfo = null;
            if (snapshotter.shouldStream()) {
                boolean shouldExport = snapshotter.exportSnapshot();
                replicationConnection = this.createReplicationConnection(this.taskContext, shouldExport, connectorConfig.maxRetries(), connectorConfig.retryDelay());
                if (slotInfo == null) {
                    try {
                        slotCreatedInfo = replicationConnection.createReplicationSlot().orElse(null);
                    }
                    catch (SQLException ex) {
                        throw new ConnectException((Throwable)ex);
                    }
                } else {
                    slotCreatedInfo = null;
                }
            }
            this.queue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).loggingContextSupplier(() -> this.taskContext.configureLoggingContext(CONTEXT_NAME)).build();
            this.errorHandler = new PostgresErrorHandler(connectorConfig.getLogicalName(), this.queue);
            PostgresEventMetadataProvider metadataProvider = new PostgresEventMetadataProvider();
            Heartbeat heartbeat = Heartbeat.create((Configuration)connectorConfig.getConfig(), (String)topicSelector.getHeartbeatTopic(), (String)connectorConfig.getLogicalName(), (JdbcConnection)this.heartbeatConnection);
            EventDispatcher dispatcher = new EventDispatcher((CommonConnectorConfig)connectorConfig, topicSelector, (DatabaseSchema)this.schema, this.queue, (DataCollectionFilters.DataCollectionFilter)connectorConfig.getTableFilters().dataCollectionFilter(), DataChangeEvent::new, PostgresChangeRecordEmitter::updateSchema, (EventMetadataProvider)metadataProvider, heartbeat);
            ChangeEventSourceCoordinator coordinator = new ChangeEventSourceCoordinator((OffsetContext)previousOffset, this.errorHandler, PostgresConnector.class, (CommonConnectorConfig)connectorConfig, (ChangeEventSourceFactory)new PostgresChangeEventSourceFactory(connectorConfig, snapshotter, this.jdbcConnection, this.errorHandler, (EventDispatcher<TableId>)dispatcher, clock, this.schema, this.taskContext, replicationConnection, slotCreatedInfo), (ChangeEventSourceMetricsFactory)new DefaultChangeEventSourceMetricsFactory(), dispatcher, (DatabaseSchema)this.schema);
            coordinator.start((CdcSourceTaskContext)this.taskContext, this.queue, (EventMetadataProvider)metadataProvider);
            ChangeEventSourceCoordinator changeEventSourceCoordinator = coordinator;
            return changeEventSourceCoordinator;
        }
        finally {
            previousContext.restore();
        }
    }

    public ReplicationConnection createReplicationConnection(PostgresTaskContext taskContext, boolean shouldExport, int maxRetries, Duration retryDelay) throws ConnectException {
        Metronome metronome = Metronome.parker((Duration)retryDelay, (Clock)Clock.SYSTEM);
        short retryCount = 0;
        ReplicationConnection replicationConnection = null;
        while (retryCount <= maxRetries) {
            try {
                return taskContext.createReplicationConnection(shouldExport);
            }
            catch (SQLException ex) {
                retryCount = (short)(retryCount + 1);
                if (retryCount > maxRetries) {
                    LOGGER.error("Too many errors connecting to server. All {} retries failed.", (Object)maxRetries);
                    throw new ConnectException((Throwable)ex);
                }
                LOGGER.warn("Error connecting to server; will attempt retry {} of {} after {} seconds. Exception message: {}", new Object[]{retryCount, maxRetries, retryDelay.getSeconds(), ex.getMessage()});
                try {
                    metronome.pause();
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Connection retry sleep interrupted by exception: " + e);
                    Thread.currentThread().interrupt();
                }
            }
        }
        return replicationConnection;
    }

    public List<SourceRecord> doPoll() throws InterruptedException {
        List records = this.queue.poll();
        List<SourceRecord> sourceRecords = records.stream().map(DataChangeEvent::getRecord).collect(Collectors.toList());
        return sourceRecords;
    }

    protected void doStop() {
        if (this.jdbcConnection != null) {
            this.jdbcConnection.close();
        }
        if (this.heartbeatConnection != null) {
            this.heartbeatConnection.close();
        }
        if (this.schema != null) {
            this.schema.close();
        }
    }

    public String version() {
        return Module.version();
    }

    protected Iterable<Field> getAllConfigurationFields() {
        return PostgresConnectorConfig.ALL_FIELDS;
    }

    public PostgresTaskContext getTaskContext() {
        return this.taskContext;
    }
}

