/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection;

import io.debezium.connector.postgresql.connection.ReplicationMessage;
import io.debezium.connector.postgresql.connection.wal2json.DateTimeFormat;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import org.apache.kafka.connect.errors.ConnectException;
import org.postgresql.geometric.PGbox;
import org.postgresql.geometric.PGcircle;
import org.postgresql.geometric.PGline;
import org.postgresql.geometric.PGlseg;
import org.postgresql.geometric.PGpath;
import org.postgresql.geometric.PGpoint;
import org.postgresql.geometric.PGpolygon;
import org.postgresql.util.PGInterval;
import org.postgresql.util.PGmoney;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractColumnValue<T>
implements ReplicationMessage.ColumnValue<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractColumnValue.class);

    @Override
    public LocalDate asLocalDate() {
        return DateTimeFormat.get().date(this.asString());
    }

    @Override
    public LocalTime asLocalTime() {
        return DateTimeFormat.get().time(this.asString());
    }

    @Override
    public OffsetTime asOffsetTimeUtc() {
        return DateTimeFormat.get().timeWithTimeZone(this.asString());
    }

    @Override
    public OffsetDateTime asOffsetDateTimeAtUtc() {
        return DateTimeFormat.get().timestampWithTimeZoneToOffsetDateTime(this.asString()).withOffsetSameInstant(ZoneOffset.UTC);
    }

    @Override
    public Instant asInstant() {
        return DateTimeFormat.get().timestampToInstant(this.asString());
    }

    @Override
    public PGbox asBox() {
        try {
            return new PGbox(this.asString());
        }
        catch (SQLException e) {
            LOGGER.error("Failed to parse point {}, {}", (Object)this.asString(), (Object)e);
            throw new ConnectException((Throwable)e);
        }
    }

    @Override
    public PGcircle asCircle() {
        try {
            return new PGcircle(this.asString());
        }
        catch (SQLException e) {
            LOGGER.error("Failed to parse circle {}, {}", (Object)this.asString(), (Object)e);
            throw new ConnectException((Throwable)e);
        }
    }

    @Override
    public PGInterval asInterval() {
        try {
            return new PGInterval(this.asString());
        }
        catch (SQLException e) {
            LOGGER.error("Failed to parse point {}, {}", (Object)this.asString(), (Object)e);
            throw new ConnectException((Throwable)e);
        }
    }

    @Override
    public PGline asLine() {
        try {
            return new PGline(this.asString());
        }
        catch (SQLException e) {
            LOGGER.error("Failed to parse point {}, {}", (Object)this.asString(), (Object)e);
            throw new ConnectException((Throwable)e);
        }
    }

    @Override
    public PGlseg asLseg() {
        try {
            return new PGlseg(this.asString());
        }
        catch (SQLException e) {
            LOGGER.error("Failed to parse point {}, {}", (Object)this.asString(), (Object)e);
            throw new ConnectException((Throwable)e);
        }
    }

    @Override
    public PGmoney asMoney() {
        try {
            return new PGmoney(this.asString());
        }
        catch (SQLException e) {
            LOGGER.error("Failed to parse money {}, {}", (Object)this.asString(), (Object)e);
            throw new ConnectException((Throwable)e);
        }
    }

    @Override
    public PGpath asPath() {
        try {
            return new PGpath(this.asString());
        }
        catch (SQLException e) {
            LOGGER.error("Failed to parse point {}, {}", (Object)this.asString(), (Object)e);
            throw new ConnectException((Throwable)e);
        }
    }

    @Override
    public PGpoint asPoint() {
        try {
            return new PGpoint(this.asString());
        }
        catch (SQLException e) {
            LOGGER.error("Failed to parse point {}, {}", (Object)this.asString(), (Object)e);
            throw new ConnectException((Throwable)e);
        }
    }

    @Override
    public PGpolygon asPolygon() {
        try {
            return new PGpolygon(this.asString());
        }
        catch (SQLException e) {
            LOGGER.error("Failed to parse point {}, {}", (Object)this.asString(), (Object)e);
            throw new ConnectException((Throwable)e);
        }
    }
}

