/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.PostgresSchema;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.connector.postgresql.connection.ReplicationConnection;
import io.debezium.relational.TableId;
import io.debezium.schema.TopicSelector;
import java.sql.SQLException;
import java.util.Collections;

@ThreadSafe
public class PostgresTaskContext
extends CdcSourceTaskContext {
    private final PostgresConnectorConfig config;
    private final TopicSelector<TableId> topicSelector;
    private final PostgresSchema schema;

    protected PostgresTaskContext(PostgresConnectorConfig config, PostgresSchema schema, TopicSelector<TableId> topicSelector) {
        super("Postgres", config.getLogicalName(), Collections::emptySet);
        this.config = config;
        this.topicSelector = topicSelector;
        assert (schema != null);
        this.schema = schema;
    }

    protected TopicSelector<TableId> topicSelector() {
        return this.topicSelector;
    }

    protected PostgresSchema schema() {
        return this.schema;
    }

    protected PostgresConnectorConfig config() {
        return this.config;
    }

    protected void refreshSchema(boolean printReplicaIdentityInfo) throws SQLException {
        try (PostgresConnection connection = this.createConnection();){
            this.schema.refresh(connection, printReplicaIdentityInfo);
        }
    }

    protected ReplicationConnection createReplicationConnection() throws SQLException {
        return ReplicationConnection.builder(this.config.jdbcConfig()).withSlot(this.config.slotName()).withPlugin(this.config.plugin()).dropSlotOnClose(this.config.dropSlotOnStop()).streamParams(this.config.streamParams()).statusUpdateIntervalMillis(this.config.statusUpdateIntervalMillis()).withTypeRegistry(this.schema.getTypeRegistry()).build();
    }

    protected PostgresConnection createConnection() {
        return new PostgresConnection(this.config.jdbcConfig());
    }

    PostgresConnectorConfig getConfig() {
        return this.config;
    }
}

