/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.schema.TopicSelector;

public interface PostgresTopicSelector
extends TopicSelector<TableId> {
    public static PostgresTopicSelector create(PostgresConnectorConfig config) {
        PostgresConnectorConfig.TopicSelectionStrategy topicSelectionStrategy = config.topicSelectionStrategy();
        switch (topicSelectionStrategy) {
            case TOPIC_PER_SCHEMA: {
                return PostgresTopicSelector.topicPerSchema(config.getLogicalName());
            }
            case TOPIC_PER_TABLE: {
                return PostgresTopicSelector.topicPerTable(config.getLogicalName());
            }
        }
        throw new IllegalArgumentException("Unknown topic selection strategy: " + (Object)((Object)topicSelectionStrategy));
    }

    public static PostgresTopicSelector topicPerTable(String prefix) {
        return tableId -> String.join((CharSequence)".", prefix, tableId.schema(), tableId.table());
    }

    public static PostgresTopicSelector topicPerSchema(String prefix) {
        return tableId -> String.join((CharSequence)".", prefix, tableId.schema());
    }
}

