/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.postgresql.Module;
import io.debezium.connector.postgresql.connection.ReplicationConnection;
import java.lang.constant.Constable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

@NotThreadSafe
final class SourceInfo
extends AbstractSourceInfo {
    public static final String SERVER_NAME_KEY = "name";
    public static final String SERVER_PARTITION_KEY = "server";
    public static final String TIMESTAMP_KEY = "ts_usec";
    public static final String TXID_KEY = "txId";
    public static final String LSN_KEY = "lsn";
    public static final String SNAPSHOT_KEY = "snapshot";
    public static final String LAST_SNAPSHOT_RECORD_KEY = "last_snapshot_record";
    public static final Schema SCHEMA = SourceInfo.schemaBuilder().name("io.debezium.connector.postgresql.Source").field("name", Schema.STRING_SCHEMA).field("ts_usec", Schema.OPTIONAL_INT64_SCHEMA).field("txId", Schema.OPTIONAL_INT64_SCHEMA).field("lsn", Schema.OPTIONAL_INT64_SCHEMA).field("snapshot", SchemaBuilder.bool().optional().defaultValue((Object)false).build()).field("last_snapshot_record", Schema.OPTIONAL_BOOLEAN_SCHEMA).build();
    private final String serverName;
    private final Map<String, String> sourcePartition;
    private Long lsn;
    private Long txId;
    private Long useconds;
    private boolean snapshot = false;
    private Boolean lastSnapshotRecord;

    protected SourceInfo(String serverName) {
        super(Module.version());
        this.serverName = serverName;
        this.sourcePartition = Collections.singletonMap(SERVER_PARTITION_KEY, serverName);
    }

    protected void load(Map<String, Object> lastStoredOffset) {
        this.lsn = ((Number)lastStoredOffset.get(LSN_KEY)).longValue();
        this.txId = ((Number)lastStoredOffset.get(TXID_KEY)).longValue();
        this.useconds = (Long)lastStoredOffset.get(TIMESTAMP_KEY);
        this.snapshot = lastStoredOffset.containsKey(SNAPSHOT_KEY);
        if (this.snapshot) {
            this.lastSnapshotRecord = (Boolean)lastStoredOffset.get(LAST_SNAPSHOT_RECORD_KEY);
        }
    }

    public Map<String, String> partition() {
        return this.sourcePartition;
    }

    public Map<String, ?> offset() {
        assert (this.serverName != null);
        HashMap<String, Constable> result = new HashMap<String, Constable>();
        if (this.useconds != null) {
            result.put(TIMESTAMP_KEY, this.useconds);
        }
        if (this.txId != null) {
            result.put(TXID_KEY, this.txId);
        }
        if (this.lsn != null) {
            result.put(LSN_KEY, this.lsn);
        }
        if (this.snapshot) {
            result.put(SNAPSHOT_KEY, Boolean.valueOf(true));
            result.put(LAST_SNAPSHOT_RECORD_KEY, this.lastSnapshotRecord);
        }
        return result;
    }

    protected SourceInfo update(Long lsn, Long useconds, Long txId) {
        this.lsn = lsn;
        this.useconds = useconds;
        this.txId = txId;
        return this;
    }

    protected SourceInfo update(Long useconds) {
        this.useconds = useconds;
        return this;
    }

    protected SourceInfo markLastSnapshotRecord() {
        this.lastSnapshotRecord = true;
        return this;
    }

    protected Schema schema() {
        return SCHEMA;
    }

    protected Struct source() {
        assert (this.serverName != null);
        Struct result = super.struct();
        result.put(SERVER_NAME_KEY, (Object)this.serverName);
        this.offset().forEach((arg_0, arg_1) -> ((Struct)result).put(arg_0, arg_1));
        return result;
    }

    protected boolean isSnapshotInEffect() {
        return this.snapshot && (this.lastSnapshotRecord == null || this.lastSnapshotRecord == false);
    }

    protected void startSnapshot() {
        this.snapshot = true;
        this.lastSnapshotRecord = false;
    }

    protected void completeSnapshot() {
        this.snapshot = false;
    }

    protected Long lsn() {
        return this.lsn;
    }

    protected boolean hasLastKnownPosition() {
        return this.lsn != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("source_info[");
        sb.append("server='").append(this.serverName).append('\'');
        if (this.lsn != null) {
            sb.append(", lsn=").append(ReplicationConnection.format(this.lsn));
        }
        if (this.txId != null) {
            sb.append(", txId=").append(this.txId);
        }
        if (this.useconds != null) {
            sb.append(", useconds=").append(this.useconds);
        }
        boolean snapshotInEffect = this.isSnapshotInEffect();
        sb.append(", snapshot=").append(snapshotInEffect);
        if (snapshotInEffect) {
            sb.append(", last_snapshot_record=").append(this.lastSnapshotRecord);
        }
        sb.append(']');
        return sb.toString();
    }
}

