/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.connector.postgresql.PostgresChangeRecordEmitter;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.PostgresOffsetContext;
import io.debezium.connector.postgresql.PostgresSchema;
import io.debezium.connector.postgresql.PostgresTaskContext;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.connector.postgresql.connection.ReplicationConnection;
import io.debezium.connector.postgresql.connection.ReplicationStream;
import io.debezium.connector.postgresql.spi.Snapshotter;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionId;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.connect.errors.ConnectException;
import org.postgresql.jdbc.PgConnection;
import org.postgresql.replication.LogSequenceNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresStreamingChangeEventSource
implements StreamingChangeEventSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresStreamingChangeEventSource.class);
    private final PostgresConnection connection;
    private final EventDispatcher<TableId> dispatcher;
    private final ErrorHandler errorHandler;
    private final Clock clock;
    private final PostgresSchema schema;
    private final PostgresOffsetContext offsetContext;
    private final PostgresConnectorConfig connectorConfig;
    private final PostgresTaskContext taskContext;
    private final ReplicationConnection replicationConnection;
    private final AtomicReference<ReplicationStream> replicationStream = new AtomicReference();
    private Long lastCompletelyProcessedLsn;
    private final Snapshotter snapshotter;
    private final Metronome pauseNoMessage;

    public PostgresStreamingChangeEventSource(PostgresConnectorConfig connectorConfig, Snapshotter snapshotter, PostgresOffsetContext offsetContext, PostgresConnection connection, EventDispatcher<TableId> dispatcher, ErrorHandler errorHandler, Clock clock, PostgresSchema schema, PostgresTaskContext taskContext, ReplicationConnection replicationConnection) {
        this.connectorConfig = connectorConfig;
        this.connection = connection;
        this.dispatcher = dispatcher;
        this.errorHandler = errorHandler;
        this.clock = clock;
        this.schema = schema;
        this.offsetContext = offsetContext != null ? offsetContext : PostgresOffsetContext.initialContext(connectorConfig, connection, clock);
        this.pauseNoMessage = Metronome.sleeper((Duration)taskContext.getConfig().getPollInterval(), (Clock)Clock.SYSTEM);
        this.taskContext = taskContext;
        this.snapshotter = snapshotter;
        this.replicationConnection = replicationConnection;
    }

    public void execute(ChangeEventSource.ChangeEventSourceContext context) throws InterruptedException {
        if (!this.snapshotter.shouldStream()) {
            LOGGER.info("Streaming is not enabled in currect configuration");
            return;
        }
        try {
            if (this.offsetContext.hasLastKnownPosition()) {
                Long lsn = this.offsetContext.lsn();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("retrieved latest position from stored offset '{}'", (Object)ReplicationConnection.format(lsn));
                }
                this.replicationStream.compareAndSet(null, this.replicationConnection.startStreaming(lsn));
            } else {
                LOGGER.info("no previous LSN found in Kafka, streaming from the latest xlogpos or flushed LSN...");
                this.replicationStream.compareAndSet(null, this.replicationConnection.startStreaming());
            }
            this.taskContext.refreshSchema(this.connection, true);
            this.lastCompletelyProcessedLsn = this.offsetContext.lsn();
            ReplicationStream stream = this.replicationStream.get();
            while (context.isRunning()) {
                if (stream.readPending(message -> {
                    Long lsn = stream.lastReceivedLsn();
                    if (message == null) {
                        LOGGER.trace("Received empty message");
                        this.lastCompletelyProcessedLsn = lsn;
                        this.dispatcher.dispatchHeartbeatEvent((OffsetContext)this.offsetContext);
                        return;
                    }
                    if (message.isLastEventForLsn()) {
                        this.lastCompletelyProcessedLsn = lsn;
                    }
                    TableId tableId = PostgresSchema.parse(message.getTable());
                    Objects.requireNonNull(tableId);
                    this.offsetContext.updateWalPosition(lsn, this.lastCompletelyProcessedLsn, message.getCommitTime(), message.getTransactionId(), tableId, this.taskContext.getSlotXmin(this.connection));
                    this.dispatcher.dispatchDataChangeEvent((DataCollectionId)tableId, (ChangeRecordEmitter)new PostgresChangeRecordEmitter(this.offsetContext, this.clock, this.connectorConfig, this.schema, this.connection, message));
                })) continue;
                if (this.offsetContext.hasCompletelyProcessedPosition()) {
                    this.dispatcher.dispatchHeartbeatEvent((OffsetContext)this.offsetContext);
                }
                this.pauseNoMessage.pause();
            }
        }
        catch (Throwable e) {
            this.errorHandler.setProducerThrowable(e);
        }
        finally {
            if (this.replicationConnection != null) {
                LOGGER.debug("stopping streaming...");
                try {
                    this.replicationConnection.close();
                }
                catch (Exception stream) {}
            }
        }
    }

    public void commitOffset(Map<String, ?> offset) {
        try {
            ReplicationStream replicationStream = this.replicationStream.get();
            Long lsn = (Long)offset.get("lsn_proc");
            if (replicationStream != null && lsn != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Flushing LSN to server: {}", (Object)LogSequenceNumber.valueOf((long)lsn));
                }
                replicationStream.flushLsn(lsn);
            } else {
                LOGGER.debug("Streaming has already stopped, ignoring commit callback...");
            }
        }
        catch (SQLException e) {
            throw new ConnectException((Throwable)e);
        }
    }

    @FunctionalInterface
    public static interface PgConnectionSupplier {
        public PgConnection get() throws SQLException;
    }
}

