/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.config.Configuration;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.TypeRegistry;
import io.debezium.connector.postgresql.connection.PostgresReplicationConnection;
import io.debezium.connector.postgresql.connection.ReplicationStream;
import java.sql.SQLException;
import java.time.Duration;
import org.postgresql.replication.LogSequenceNumber;

@NotThreadSafe
public interface ReplicationConnection
extends AutoCloseable {
    public ReplicationStream startStreaming() throws SQLException, InterruptedException;

    public ReplicationStream startStreaming(Long var1) throws SQLException, InterruptedException;

    public boolean isConnected() throws SQLException;

    public static Builder builder(Configuration jdbcConfig) {
        return new PostgresReplicationConnection.ReplicationConnectionBuilder(jdbcConfig);
    }

    public static String format(long lsn) {
        return LogSequenceNumber.valueOf((long)lsn).asString();
    }

    public static interface Builder {
        public static final String DEFAULT_SLOT_NAME = "debezium";
        public static final boolean DEFAULT_DROP_SLOT_ON_CLOSE = true;

        public Builder withSlot(String var1);

        public Builder withPlugin(PostgresConnectorConfig.LogicalDecoder var1);

        public Builder dropSlotOnClose(boolean var1);

        public Builder statusUpdateInterval(Duration var1);

        public Builder withTypeRegistry(TypeRegistry var1);

        public Builder streamParams(String var1);

        public ReplicationConnection build();
    }
}

