/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.buffered.infinispan;

import io.debezium.connector.oracle.logminer.buffered.LogMinerCache;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.api.BasicCache;

public class InfinispanLogMinerCache<K, V>
implements LogMinerCache<K, V> {
    private final BasicCache<K, V> cache;

    public InfinispanLogMinerCache(BasicCache<K, V> cache) {
        this.cache = cache;
    }

    @Override
    public boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public V remove(K key) {
        BasicCache<K, V> basicCache = this.cache;
        if (basicCache instanceof RemoteCache) {
            RemoteCache remoteCache = (RemoteCache)basicCache;
            return (V)remoteCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove(key);
        }
        return (V)this.cache.remove(key);
    }

    @Override
    public V get(K key) {
        return (V)this.cache.get(key);
    }

    @Override
    public void put(K key, V value) {
        this.cache.put(key, value);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void forEach(BiConsumer<K, V> action) {
        this.cache.forEach(action);
    }

    @Override
    public void removeIf(Predicate<LogMinerCache.Entry<K, V>> predicate) {
        this.cache.entrySet().removeIf((? super E kvEntry) -> predicate.test(new LogMinerCache.Entry(kvEntry.getKey(), kvEntry.getValue())));
    }

    @Override
    public void entries(Consumer<Stream<LogMinerCache.Entry<K, V>>> streamConsumer) {
        try (Stream<LogMinerCache.Entry> stream = this.cache.entrySet().stream().map(e -> new LogMinerCache.Entry(e.getKey(), e.getValue()));){
            streamConsumer.accept(stream);
        }
    }

    @Override
    public <T> T streamAndReturn(Function<Stream<LogMinerCache.Entry<K, V>>, T> function) {
        try (Stream stream = this.cache.entrySet().stream();){
            T t = function.apply(stream.map(e -> new LogMinerCache.Entry(e.getKey(), e.getValue())));
            return t;
        }
    }
}

