/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.buffered.ehcache.serialization;

import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.buffered.ehcache.EhcacheTransaction;
import io.debezium.connector.oracle.logminer.buffered.ehcache.serialization.AbstractEhcacheSerializer;
import io.debezium.connector.oracle.logminer.buffered.ehcache.serialization.SerializerInputStream;
import io.debezium.connector.oracle.logminer.buffered.ehcache.serialization.SerializerOutputStream;
import java.io.IOException;
import java.time.Instant;

public class EhcacheTransactionSerializer
extends AbstractEhcacheSerializer<EhcacheTransaction> {
    public EhcacheTransactionSerializer(ClassLoader classLoader) {
    }

    @Override
    protected void serialize(EhcacheTransaction object, SerializerOutputStream stream) throws IOException {
        stream.writeString(object.getTransactionId());
        stream.writeScn(object.getStartScn());
        stream.writeInstant(object.getChangeTime());
        stream.writeString(object.getUserName());
        stream.writeInt(object.getRedoThreadId());
        stream.writeInt(object.getNumberOfEvents());
        stream.writeString(object.getClientId());
    }

    @Override
    protected EhcacheTransaction deserialize(SerializerInputStream stream) throws IOException {
        String transactionId = stream.readString();
        Scn startScn = this.readScn(stream.readString());
        Instant changeTime = stream.readInstant();
        String userName = stream.readString();
        int redoThread = stream.readInt();
        int numberOfEvents = stream.readInt();
        String clientId = stream.readString();
        return new EhcacheTransaction(transactionId, startScn, changeTime, userName, redoThread, numberOfEvents, clientId);
    }

    private Scn readScn(String value) {
        return value.equals("null") ? Scn.NULL : Scn.valueOf(value);
    }
}

