/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.buffered;

import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.buffered.Transaction;
import io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public interface LogMinerTransactionCache<T extends Transaction> {
    public T getTransaction(String var1);

    public T getAndRemoveTransaction(String var1);

    public void addTransaction(T var1);

    public void removeTransaction(T var1);

    public boolean containsTransaction(String var1);

    public boolean isEmpty();

    public int getTransactionCount();

    public Optional<ScnDetails> getEldestTransactionScnDetailsInCache();

    public <R> R streamTransactionsAndReturn(Function<Stream<T>, R> var1);

    public void transactions(Consumer<Stream<T>> var1);

    public LogMinerEvent getTransactionEvent(T var1, int var2);

    public void eventKeys(Consumer<Stream<String>> var1);

    public void forEachEvent(T var1, InterruptiblePredicate<LogMinerEvent> var2) throws InterruptedException;

    public void addTransactionEvent(T var1, int var2, LogMinerEvent var3);

    public void removeTransactionEvents(T var1);

    public boolean removeTransactionEventWithRowId(T var1, String var2);

    public boolean containsTransactionEvent(T var1, int var2);

    public int getTransactionEventCount(T var1);

    public int getTransactionEvents();

    public void abandon(T var1);

    public void removeAbandonedTransaction(String var1);

    public boolean isAbandoned(String var1);

    public void clear();

    public void resetTransactionToStart(T var1);

    public void syncTransaction(T var1);

    @FunctionalInterface
    public static interface InterruptiblePredicate<T> {
        public boolean test(T var1) throws InterruptedException;
    }

    public record ScnDetails(Scn scn, Instant changeTime) {
    }
}

