/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.LogMinerStreamingChangeEventSourceMetrics;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetActivityMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(OffsetActivityMonitor.class);
    private final int staleMaxIterations;
    private final OracleOffsetContext offsetContext;
    private final LogMinerStreamingChangeEventSourceMetrics metrics;
    private int unchangedScnCount;
    private Scn previousOffsetScn = Scn.NULL;
    private Map<Integer, Scn> previousCommitScns = new HashMap<Integer, Scn>();

    public OffsetActivityMonitor(int staleMaxIterations, OracleOffsetContext offsetContext, LogMinerStreamingChangeEventSourceMetrics metrics) {
        this.staleMaxIterations = staleMaxIterations;
        this.offsetContext = offsetContext;
        this.metrics = metrics;
    }

    public void checkForStaleOffsets() {
        if (this.offsetContext.getCommitScn() != null) {
            Scn currentScn = this.offsetContext.getScn();
            Map<Integer, Scn> currentCommitScns = this.offsetContext.getCommitScn().getCommitScnForAllRedoThreads();
            if (this.previousOffsetScn.equals(currentScn) && !this.previousOffsetScn.equals(currentCommitScns)) {
                ++this.unchangedScnCount;
                if (this.unchangedScnCount == this.staleMaxIterations) {
                    LOGGER.warn("Offset SCN {} has not changed in {} mining session iterations. This indicates long running transaction(s) are active. Commit SCNs {}.", new Object[]{this.previousOffsetScn, this.staleMaxIterations, this.previousCommitScns});
                    this.metrics.incrementScnFreezeCount();
                    this.unchangedScnCount = 0;
                }
            } else {
                this.metrics.setScnFreezeCount(0L);
                this.unchangedScnCount = 0;
            }
        }
        this.previousOffsetScn = this.offsetContext.getScn();
        if (this.offsetContext.getCommitScn() != null) {
            this.previousCommitScns = this.offsetContext.getCommitScn().getCommitScnForAllRedoThreads();
        }
    }
}

