/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor.ehcache.serialization;

import io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import io.debezium.connector.oracle.logminer.processor.ehcache.serialization.AbstractEhcacheSerializer;
import io.debezium.connector.oracle.logminer.processor.ehcache.serialization.DeserializationContext;
import io.debezium.connector.oracle.logminer.processor.ehcache.serialization.DmlEventSerdesProvider;
import io.debezium.connector.oracle.logminer.processor.ehcache.serialization.ExtendedStringBeginEventSerdesProvider;
import io.debezium.connector.oracle.logminer.processor.ehcache.serialization.ExtendedStringWriteEventSerdesProvider;
import io.debezium.connector.oracle.logminer.processor.ehcache.serialization.LobEraseEventSerdesProvider;
import io.debezium.connector.oracle.logminer.processor.ehcache.serialization.LobWriteEventSerdesProvider;
import io.debezium.connector.oracle.logminer.processor.ehcache.serialization.LogMinerEventSerdesProvider;
import io.debezium.connector.oracle.logminer.processor.ehcache.serialization.RedoSqlDmlEventSerdesProvider;
import io.debezium.connector.oracle.logminer.processor.ehcache.serialization.SelectLobLocatorSerdesProvider;
import io.debezium.connector.oracle.logminer.processor.ehcache.serialization.SerdesProvider;
import io.debezium.connector.oracle.logminer.processor.ehcache.serialization.SerializerInputStream;
import io.debezium.connector.oracle.logminer.processor.ehcache.serialization.SerializerOutputStream;
import io.debezium.connector.oracle.logminer.processor.ehcache.serialization.TruncateEventSerdesProvider;
import io.debezium.connector.oracle.logminer.processor.ehcache.serialization.XmlBeginEventSerdesProvider;
import io.debezium.connector.oracle.logminer.processor.ehcache.serialization.XmlEndEventSerdesProvider;
import io.debezium.connector.oracle.logminer.processor.ehcache.serialization.XmlWriteEventSerdesProvider;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ehcache.spi.serialization.SerializerException;

public class LogMinerEventSerializer
extends AbstractEhcacheSerializer<LogMinerEvent> {
    private static final Map<Class<?>, Class<?>> primitiveToWrapperMap = new HashMap();
    private final Map<String, SerdesProvider<?>> serdesProviders = new HashMap();
    private final Map<Class<?>, Constructor<?>> constructorCache = new ConcurrentHashMap();

    public LogMinerEventSerializer(ClassLoader classLoader) {
        this.registerSerdesProviders();
    }

    @Override
    protected void serialize(LogMinerEvent object, SerializerOutputStream stream) throws IOException {
        SerdesProvider<?> serdes = this.getSerdesByClassName(object.getClass().getName());
        stream.writeString(object.getClass().getName());
        serdes.serialize(object, stream);
    }

    @Override
    protected LogMinerEvent deserialize(SerializerInputStream stream) throws IOException {
        String clazzName = stream.readString();
        SerdesProvider<?> serdes = this.getSerdesByClassName(clazzName);
        DeserializationContext context = new DeserializationContext();
        serdes.deserialize(context, stream);
        return this.constructObject(serdes.getJavaType(), context);
    }

    private void registerSerdesProviders() {
        this.registerSerdes(new DmlEventSerdesProvider());
        this.registerSerdes(new LobEraseEventSerdesProvider());
        this.registerSerdes(new LobWriteEventSerdesProvider());
        this.registerSerdes(new LogMinerEventSerdesProvider());
        this.registerSerdes(new RedoSqlDmlEventSerdesProvider());
        this.registerSerdes(new SelectLobLocatorSerdesProvider());
        this.registerSerdes(new TruncateEventSerdesProvider());
        this.registerSerdes(new XmlBeginEventSerdesProvider());
        this.registerSerdes(new XmlEndEventSerdesProvider());
        this.registerSerdes(new XmlWriteEventSerdesProvider());
        this.registerSerdes(new ExtendedStringBeginEventSerdesProvider());
        this.registerSerdes(new ExtendedStringWriteEventSerdesProvider());
    }

    private <T> void registerSerdes(SerdesProvider<T> serdesProvider) {
        this.serdesProviders.put(serdesProvider.getJavaType().getName(), serdesProvider);
    }

    private SerdesProvider<?> getSerdesByClassName(String clazzName) {
        SerdesProvider<?> provider = this.serdesProviders.get(clazzName);
        if (provider == null) {
            throw new SerializerException("Failed to find SerdesProvider for class: " + clazzName);
        }
        return provider;
    }

    private LogMinerEvent constructObject(Class<?> clazz, DeserializationContext context) {
        try {
            List<Object> values = context.getValues();
            Constructor constructor = this.constructorCache.computeIfAbsent(clazz, classType -> {
                Object[] parameterTypes = this.getParameterTypes(values);
                Constructor<?> result = this.getMatchingConstructor(clazz, (Class<?>[])parameterTypes);
                if (result == null) {
                    throw new SerializerException("Failed to find matching constructor for argument types: " + Arrays.toString(parameterTypes));
                }
                return result;
            });
            return (LogMinerEvent)constructor.newInstance(values.toArray());
        }
        catch (Exception e) {
            throw new SerializerException("Failed to construct object of type " + clazz.getName(), (Throwable)e);
        }
    }

    private Class<?>[] getParameterTypes(List<Object> values) {
        return (Class[])values.stream().map(Object::getClass).toArray(Class[]::new);
    }

    private Constructor<?> getMatchingConstructor(Class<?> clazz, Class<?>[] parameterTypes) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            Class<?>[] paramTypes = constructor.getParameterTypes();
            if (paramTypes.length != parameterTypes.length) continue;
            boolean matches = true;
            for (int i = 0; i < paramTypes.length; ++i) {
                if (paramTypes[i].isAssignableFrom(parameterTypes[i]) || parameterTypes[i].isAssignableFrom(paramTypes[i]) || LogMinerEventSerializer.isWrapperPrimitiveMatch(paramTypes[i], parameterTypes[i])) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return constructor;
        }
        return null;
    }

    private static boolean isWrapperPrimitiveMatch(Class<?> paramType, Class<?> argType) {
        if (paramType.isPrimitive()) {
            return argType.equals(primitiveToWrapperMap.get(paramType));
        }
        return false;
    }

    static {
        primitiveToWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveToWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveToWrapperMap.put(Character.TYPE, Character.class);
        primitiveToWrapperMap.put(Short.TYPE, Short.class);
        primitiveToWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveToWrapperMap.put(Long.TYPE, Long.class);
        primitiveToWrapperMap.put(Float.TYPE, Float.class);
        primitiveToWrapperMap.put(Double.TYPE, Double.class);
    }
}

