/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor;

import java.util.HashMap;
import java.util.Map;

public class InMemoryPendingTransactionsCache {
    private final Map<String, Integer> pendingTransactionInEventsCache = new HashMap<String, Integer>();

    public int getNumPending(String transactionId) {
        return this.pendingTransactionInEventsCache.getOrDefault(transactionId, 0);
    }

    public void putOrIncrement(String transactionId) {
        this.pendingTransactionInEventsCache.compute(transactionId, (k, value) -> {
            value = value == null ? 0 : value;
            return value + 1;
        });
    }

    public void decrement(String transactionId) {
        this.pendingTransactionInEventsCache.compute(transactionId, (k, value) -> value == null || value == 0 ? 0 : value - 1);
    }

    public void initKey(String transactionId, int count) {
        this.pendingTransactionInEventsCache.put(transactionId, count);
    }

    public Integer remove(String transactionId) {
        return this.pendingTransactionInEventsCache.remove(transactionId);
    }
}

