/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.SnapshotType;
import io.debezium.connector.oracle.CommitScn;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.Scn;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotContext;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.TableId;
import java.util.Map;

public class LogMinerOracleOffsetContextLoader
implements OffsetContext.Loader<OracleOffsetContext> {
    private final OracleConnectorConfig connectorConfig;

    public LogMinerOracleOffsetContextLoader(OracleConnectorConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
    }

    public OracleOffsetContext load(Map<String, ?> offset) {
        SnapshotType snapshot = this.loadSnapshot(offset).orElse(null);
        boolean snapshotCompleted = this.loadSnapshotCompleted(offset);
        Scn scn = OracleOffsetContext.getScnFromOffsetMapByKey(offset, "scn");
        CommitScn commitScn = CommitScn.load(offset);
        Map<String, Scn> snapshotPendingTransactions = OracleOffsetContext.loadSnapshotPendingTransactions(offset);
        Scn snapshotScn = OracleOffsetContext.loadSnapshotScn(offset);
        return new OracleOffsetContext(this.connectorConfig, scn, null, commitScn, null, snapshotScn, snapshotPendingTransactions, snapshot, snapshotCompleted, TransactionContext.load(offset), (IncrementalSnapshotContext<TableId>)SignalBasedIncrementalSnapshotContext.load(offset));
    }
}

