/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.snapshot.query;

import io.debezium.bean.StandardBeanNames;
import io.debezium.bean.spi.BeanRegistry;
import io.debezium.bean.spi.BeanRegistryAware;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.relational.RelationalSnapshotChangeEventSource;
import io.debezium.snapshot.spi.SnapshotQuery;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SelectAllSnapshotQuery
implements SnapshotQuery,
BeanRegistryAware {
    private BeanRegistry beanRegistry;

    public String name() {
        return CommonConnectorConfig.SnapshotQueryMode.SELECT_ALL.getValue();
    }

    public void configure(Map<String, ?> properties) {
    }

    public void injectBeanRegistry(BeanRegistry beanRegistry) {
        this.beanRegistry = beanRegistry;
    }

    public Optional<String> snapshotQuery(String tableId, List<String> snapshotSelectColumns) {
        RelationalSnapshotChangeEventSource.RelationalSnapshotContext snapshotContext = (RelationalSnapshotChangeEventSource.RelationalSnapshotContext)this.beanRegistry.lookupByName(StandardBeanNames.SNAPSHOT_CONTEXT, RelationalSnapshotChangeEventSource.RelationalSnapshotContext.class);
        OracleOffsetContext offset = (OracleOffsetContext)snapshotContext.offset;
        String snapshotOffset = offset.getScn().toString();
        String columns = String.join((CharSequence)", ", snapshotSelectColumns);
        assert (snapshotOffset != null);
        return Optional.of(String.format("SELECT %s FROM %s AS OF SCN %s", columns, tableId, snapshotOffset));
    }
}

