/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.rest;

import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.connector.oracle.Module;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.rest.ConnectionValidationResource;
import io.debezium.rest.FilterValidationResource;
import io.debezium.rest.SchemaResource;
import io.debezium.rest.model.DataCollection;
import io.debezium.util.Strings;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.kafka.connect.connector.Connector;

@Path(value="/debezium/oracle")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class DebeziumOracleConnectorResource
implements SchemaResource,
ConnectionValidationResource,
FilterValidationResource {
    public static final String BASE_PATH = "/debezium/oracle";
    public static final String VERSION_ENDPOINT = "/version";

    public String getSchemaFilePath() {
        return "/META-INF/resources/oracle.json";
    }

    public Connector getConnector() {
        return new OracleConnector();
    }

    public List<DataCollection> getMatchingCollections(Configuration configuration) {
        List<DataCollection> list;
        OracleConnectorConfig oracleConfig = new OracleConnectorConfig(configuration);
        String databaseName = oracleConfig.getCatalogName();
        OracleConnection connection = new OracleConnection(oracleConfig.getJdbcConfig(), false);
        try {
            if (!Strings.isNullOrBlank((String)oracleConfig.getPdbName())) {
                connection.setSessionToPdb(oracleConfig.getPdbName());
            }
            Set<TableId> tables = connection.readTableNames(databaseName, null, null, new String[]{"TABLE"});
            list = tables.stream().filter(tableId -> oracleConfig.getTableFilters().dataCollectionFilter().isIncluded(tableId)).map(tableId -> new DataCollection(tableId.schema(), tableId.table())).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                throw new DebeziumException((Throwable)e);
            }
        }
        connection.close();
        return list;
    }

    @GET
    @Path(value="/version")
    public String getConnectorVersion() {
        return Module.version();
    }
}

