/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor.infinispan;

import io.debezium.DebeziumException;
import io.debezium.config.Field;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import io.debezium.connector.oracle.logminer.processor.infinispan.AbstractInfinispanLogMinerEventProcessor;
import io.debezium.connector.oracle.logminer.processor.infinispan.CacheProvider;
import io.debezium.connector.oracle.logminer.processor.infinispan.InfinispanTransaction;
import io.debezium.connector.oracle.logminer.processor.infinispan.marshalling.LogMinerEventMarshallerImpl;
import io.debezium.connector.oracle.logminer.processor.infinispan.marshalling.TransactionMarshallerImpl;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.relational.TableId;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.configuration.XMLStringConfiguration;
import org.infinispan.commons.util.CloseableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteInfinispanLogMinerEventProcessor
extends AbstractInfinispanLogMinerEventProcessor
implements CacheProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteInfinispanLogMinerEventProcessor.class);
    private static final String HOTROD_CLIENT_LOOKUP_PREFIX = "log.mining.buffer.infinispan.client.";
    private static final String HOTROD_CLIENT_PREFIX = "infinispan.client.";
    public static final String HOTROD_SERVER_LIST = "log.mining.buffer.infinispan.client.hotrod.server_list";
    private final RemoteCacheManager cacheManager;
    private final boolean dropBufferOnStop;
    private final RemoteCache<String, InfinispanTransaction> transactionCache;
    private final RemoteCache<String, LogMinerEvent> eventCache;
    private final RemoteCache<String, String> processedTransactionsCache;
    private final RemoteCache<String, String> schemaChangesCache;

    public RemoteInfinispanLogMinerEventProcessor(ChangeEventSource.ChangeEventSourceContext context, OracleConnectorConfig connectorConfig, OracleConnection jdbcConnection, EventDispatcher<OraclePartition, TableId> dispatcher, OraclePartition partition, OracleOffsetContext offsetContext, OracleDatabaseSchema schema, OracleStreamingChangeEventSourceMetrics metrics) {
        super(context, connectorConfig, jdbcConnection, dispatcher, partition, offsetContext, schema, metrics);
        Configuration config = new ConfigurationBuilder().withProperties(this.getHotrodClientProperties(connectorConfig)).addContextInitializer(TransactionMarshallerImpl.class.getName()).addContextInitializer(LogMinerEventMarshallerImpl.class.getName()).build();
        LOGGER.info("Using Infinispan in Hotrod client mode");
        this.cacheManager = new RemoteCacheManager(config, true);
        this.dropBufferOnStop = connectorConfig.isLogMiningBufferDropOnStop();
        this.transactionCache = this.createCache("transactions", connectorConfig, OracleConnectorConfig.LOG_MINING_BUFFER_INFINISPAN_CACHE_TRANSACTIONS);
        this.processedTransactionsCache = this.createCache("processed-transactions", connectorConfig, OracleConnectorConfig.LOG_MINING_BUFFER_INFINISPAN_CACHE_PROCESSED_TRANSACTIONS);
        this.schemaChangesCache = this.createCache("schema-changes", connectorConfig, OracleConnectorConfig.LOG_MINING_BUFFER_INFINISPAN_CACHE_SCHEMA_CHANGES);
        this.eventCache = this.createCache("events", connectorConfig, OracleConnectorConfig.LOG_MINING_BUFFER_INFINISPAN_CACHE_EVENTS);
        this.displayCacheStatistics();
    }

    @Override
    public void close() throws Exception {
        if (this.dropBufferOnStop) {
            LOGGER.info("Clearing infinispan caches");
            this.transactionCache.clear();
            this.eventCache.clear();
            this.schemaChangesCache.clear();
            this.processedTransactionsCache.clear();
            this.cacheManager.administration().removeCache("transactions");
            this.cacheManager.administration().removeCache("processed-transactions");
            this.cacheManager.administration().removeCache("schema-changes");
            this.cacheManager.administration().removeCache("events");
        }
        LOGGER.info("Shutting down infinispan remote caches");
        this.cacheManager.close();
    }

    @Override
    public BasicCache<String, InfinispanTransaction> getTransactionCache() {
        return this.transactionCache;
    }

    @Override
    public BasicCache<String, LogMinerEvent> getEventCache() {
        return this.eventCache;
    }

    @Override
    public BasicCache<String, String> getSchemaChangesCache() {
        return this.schemaChangesCache;
    }

    @Override
    public BasicCache<String, String> getProcessedTransactionsCache() {
        return this.processedTransactionsCache;
    }

    @Override
    protected Scn getTransactionCacheMinimumScn() {
        Scn minimumScn = Scn.NULL;
        try (CloseableIterator iterator = this.transactionCache.values().iterator();){
            while (iterator.hasNext()) {
                Scn transactionScn = ((InfinispanTransaction)iterator.next()).getStartScn();
                if (minimumScn.isNull()) {
                    minimumScn = transactionScn;
                    continue;
                }
                if (transactionScn.compareTo(minimumScn) >= 0) continue;
                minimumScn = transactionScn;
            }
        }
        return minimumScn;
    }

    private Properties getHotrodClientProperties(OracleConnectorConfig connectorConfig) {
        Map clientSettings = connectorConfig.getConfig().subset(HOTROD_CLIENT_LOOKUP_PREFIX, true).asMap();
        Properties properties = new Properties();
        for (Map.Entry entry : clientSettings.entrySet()) {
            properties.put(HOTROD_CLIENT_PREFIX + (String)entry.getKey(), entry.getValue());
            if (!((String)entry.getKey()).toLowerCase().endsWith("infinispan.client.hotrod.auth_username".toLowerCase())) continue;
            properties.put("infinispan.client.hotrod.use_auth", "true");
        }
        return properties;
    }

    private <C, V> RemoteCache<C, V> createCache(String cacheName, OracleConnectorConfig connectorConfig, Field field) {
        Objects.requireNonNull(cacheName);
        RemoteCache cache = this.cacheManager.getCache(cacheName);
        if (cache != null) {
            LOGGER.info("Remote cache '{}' already defined.", (Object)cacheName);
            return cache;
        }
        String cacheConfiguration = connectorConfig.getConfig().getString(field);
        Objects.requireNonNull(cacheConfiguration);
        cache = this.cacheManager.administration().createCache(cacheName, (BasicConfiguration)new XMLStringConfiguration(cacheConfiguration));
        if (cache == null) {
            throw new DebeziumException("Failed to create remote Infinispan cache: " + cacheName);
        }
        LOGGER.info("Created remote infinispan cache: {}", (Object)cacheName);
        return cache;
    }
}

