/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.valueholder;

import io.debezium.connector.oracle.logminer.valueholder.LogMinerDmlEntry;
import java.util.Arrays;
import java.util.Objects;

public class LogMinerDmlEntryImpl
implements LogMinerDmlEntry {
    private final int operation;
    private final Object[] newValues;
    private final Object[] oldValues;
    private String objectOwner;
    private String objectName;

    private LogMinerDmlEntryImpl(int operation, Object[] newValues, Object[] oldValues) {
        this.operation = operation;
        this.newValues = newValues;
        this.oldValues = oldValues;
    }

    public static LogMinerDmlEntry forInsert(Object[] newColumnValues) {
        return new LogMinerDmlEntryImpl(1, newColumnValues, new Object[0]);
    }

    public static LogMinerDmlEntry forUpdate(Object[] newColumnValues, Object[] oldColumnValues) {
        return new LogMinerDmlEntryImpl(3, newColumnValues, oldColumnValues);
    }

    public static LogMinerDmlEntry forDelete(Object[] oldColumnValues) {
        return new LogMinerDmlEntryImpl(2, new Object[0], oldColumnValues);
    }

    public static LogMinerDmlEntry forLobLocator(Object[] newColumnValues) {
        Object[] oldColumnValues = Arrays.copyOf(newColumnValues, newColumnValues.length);
        return new LogMinerDmlEntryImpl(9, newColumnValues, oldColumnValues);
    }

    @Override
    public int getOperation() {
        return this.operation;
    }

    @Override
    public Object[] getOldValues() {
        return this.oldValues;
    }

    @Override
    public Object[] getNewValues() {
        return this.newValues;
    }

    @Override
    public String getObjectOwner() {
        return this.objectOwner;
    }

    @Override
    public String getObjectName() {
        return this.objectName;
    }

    @Override
    public void setObjectName(String name) {
        this.objectName = name;
    }

    @Override
    public void setObjectOwner(String name) {
        this.objectOwner = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogMinerDmlEntryImpl that = (LogMinerDmlEntryImpl)o;
        return this.operation == that.operation && Arrays.equals(this.newValues, that.newValues) && Arrays.equals(this.oldValues, that.oldValues);
    }

    public int hashCode() {
        return Objects.hash(this.operation, this.newValues, this.oldValues);
    }

    public String toString() {
        return "{LogMinerDmlEntryImpl={operation=" + this.operation + ",newColumns=" + this.newValues + ",oldColumns=" + this.oldValues + "}";
    }
}

