/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.parser;

import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.connector.oracle.antlr.listener.ParserUtils;
import io.debezium.connector.oracle.logminer.parser.DmlParser;
import io.debezium.connector.oracle.logminer.parser.DmlParserException;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerColumnValue;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerColumnValueImpl;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerColumnValueWrapper;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerDmlEntry;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerDmlEntryImpl;
import io.debezium.data.Envelope;
import io.debezium.relational.Column;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.text.ParsingException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitorAdapter;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.update.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDmlParser
implements DmlParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleDmlParser.class);
    protected final String catalogName;
    private final OracleValueConverters converter;
    private final CCJSqlParserManager pm;
    private final Map<String, LogMinerColumnValueWrapper> newColumnValues = new LinkedHashMap<String, LogMinerColumnValueWrapper>();
    private final Map<String, LogMinerColumnValueWrapper> oldColumnValues = new LinkedHashMap<String, LogMinerColumnValueWrapper>();
    protected io.debezium.relational.Table table;
    private String aliasName;

    public SimpleDmlParser(String catalogName, OracleValueConverters converter) {
        this.catalogName = catalogName;
        this.converter = converter;
        this.pm = new CCJSqlParserManager();
    }

    @Override
    public LogMinerDmlEntry parse(String dmlContent, Tables tables, TableId tableId, String txId) {
        try {
            if (dmlContent == null) {
                LOGGER.debug("Cannot parse NULL , transaction: {}", (Object)txId);
                return null;
            }
            if (dmlContent.endsWith(";null;")) {
                dmlContent = dmlContent.substring(0, dmlContent.lastIndexOf(";null;"));
            }
            if (!dmlContent.endsWith(";")) {
                dmlContent = dmlContent + ";";
            }
            dmlContent = dmlContent.replaceAll("\\\\", "\\\\\\\\");
            dmlContent = dmlContent.replaceAll("= Unsupported Type", "= null");
            this.newColumnValues.clear();
            this.oldColumnValues.clear();
            Statement st = this.pm.parse((Reader)new StringReader(dmlContent));
            if (st instanceof Update) {
                this.parseUpdate(tables, tableId, (Update)st);
                List<LogMinerColumnValue> actualNewValues = this.newColumnValues.values().stream().filter(LogMinerColumnValueWrapper::isProcessed).map(LogMinerColumnValueWrapper::getColumnValue).collect(Collectors.toList());
                List<LogMinerColumnValue> actualOldValues = this.oldColumnValues.values().stream().filter(LogMinerColumnValueWrapper::isProcessed).map(LogMinerColumnValueWrapper::getColumnValue).collect(Collectors.toList());
                return new LogMinerDmlEntryImpl(Envelope.Operation.UPDATE, actualNewValues, actualOldValues);
            }
            if (st instanceof Insert) {
                this.parseInsert(tables, tableId, (Insert)st);
                List<LogMinerColumnValue> actualNewValues = this.newColumnValues.values().stream().map(LogMinerColumnValueWrapper::getColumnValue).collect(Collectors.toList());
                return new LogMinerDmlEntryImpl(Envelope.Operation.CREATE, actualNewValues, Collections.emptyList());
            }
            if (st instanceof Delete) {
                this.parseDelete(tables, tableId, (Delete)st);
                List<LogMinerColumnValue> actualOldValues = this.oldColumnValues.values().stream().map(LogMinerColumnValueWrapper::getColumnValue).collect(Collectors.toList());
                return new LogMinerDmlEntryImpl(Envelope.Operation.DELETE, Collections.emptyList(), actualOldValues);
            }
            throw new DmlParserException("Unexpected DML operation not supported");
        }
        catch (Throwable e) {
            throw new DmlParserException("Cannot parse DML: " + dmlContent, e);
        }
    }

    private void initColumns(Tables tables, TableId tableId, String tableName) {
        if (!tableId.table().equals(tableName)) {
            throw new ParsingException(null, "Resolved TableId expected table name '" + tableId.table() + "' but is '" + tableName + "'");
        }
        this.table = tables.forTable(tableId);
        if (this.table == null) {
            throw new ParsingException(null, "Trying to parse a table '" + tableId + "', which does not exist.");
        }
        for (int i = 0; i < this.table.columns().size(); ++i) {
            Column column = (Column)this.table.columns().get(i);
            int type = column.jdbcType();
            String key = column.name();
            String name = ParserUtils.stripeQuotes(column.name().toUpperCase());
            this.newColumnValues.put(key, new LogMinerColumnValueWrapper(new LogMinerColumnValueImpl(name, type)));
            this.oldColumnValues.put(key, new LogMinerColumnValueWrapper(new LogMinerColumnValueImpl(name, type)));
        }
    }

    private void parseUpdate(Tables tables, TableId tableId, Update st) throws JSQLParserException {
        int tableCount = st.getTables().size();
        if (tableCount > 1 || tableCount == 0) {
            throw new JSQLParserException("DML includes " + tableCount + " tables");
        }
        Table parseTable = (Table)st.getTables().get(0);
        this.initColumns(tables, tableId, ParserUtils.stripeQuotes(parseTable.getName()));
        List columns = st.getColumns();
        Alias alias = parseTable.getAlias();
        this.aliasName = alias == null ? "" : alias.getName().trim();
        List expressions = st.getExpressions();
        this.setNewValues(expressions, columns);
        Expression where = st.getWhere();
        if (where != null) {
            this.parseWhereClause(where);
            ParserUtils.cloneOldToNewColumnValues(this.newColumnValues, this.oldColumnValues, this.table);
        } else {
            this.oldColumnValues.clear();
        }
    }

    private void parseInsert(Tables tables, TableId tableId, Insert st) {
        this.initColumns(tables, tableId, ParserUtils.stripeQuotes(st.getTable().getName()));
        Alias alias = st.getTable().getAlias();
        this.aliasName = alias == null ? "" : alias.getName().trim();
        final List columns = st.getColumns();
        ItemsList values = st.getItemsList();
        values.accept((ItemsListVisitor)new ItemsListVisitorAdapter(){

            public void visit(ExpressionList expressionList) {
                super.visit(expressionList);
                List expressions = expressionList.getExpressions();
                SimpleDmlParser.this.setNewValues(expressions, columns);
            }
        });
        this.oldColumnValues.clear();
    }

    private void parseDelete(Tables tables, TableId tableId, Delete st) {
        this.initColumns(tables, tableId, ParserUtils.stripeQuotes(st.getTable().getName()));
        Alias alias = st.getTable().getAlias();
        this.aliasName = alias == null ? "" : alias.getName().trim();
        this.newColumnValues.clear();
        Expression where = st.getWhere();
        if (where != null) {
            this.parseWhereClause(where);
        } else {
            this.oldColumnValues.clear();
        }
    }

    private void setNewValues(List<Expression> expressions, List<net.sf.jsqlparser.schema.Column> columns) {
        if (expressions.size() != columns.size()) {
            throw new RuntimeException("DML has " + expressions.size() + " column values, but Table object has " + columns.size() + " columns");
        }
        for (int i = 0; i < columns.size(); ++i) {
            String columnName = ParserUtils.stripeQuotes(columns.get(i).getColumnName().toUpperCase());
            String value = ParserUtils.stripeQuotes(expressions.get(i).toString());
            String stripedValue = ParserUtils.removeApostrophes(value);
            Column column = this.table.columnWithName(columnName);
            if (column == null) {
                LOGGER.trace("excluded column: {}", (Object)columnName);
                continue;
            }
            Object valueObject = ParserUtils.convertValueToSchemaType(column, stripedValue, this.converter);
            LogMinerColumnValueWrapper logMinerColumnValueWrapper = this.newColumnValues.get(columnName);
            if (logMinerColumnValueWrapper == null) continue;
            logMinerColumnValueWrapper.setProcessed(true);
            logMinerColumnValueWrapper.getColumnValue().setColumnData(valueObject);
        }
    }

    private void parseWhereClause(Expression logicalExpression) {
        logicalExpression.accept((ExpressionVisitor)new ExpressionVisitorAdapter(){

            public void visit(EqualsTo expr) {
                super.visit(expr);
                String columnName = expr.getLeftExpression().toString();
                columnName = ParserUtils.stripeAlias(columnName, SimpleDmlParser.this.aliasName);
                String value = expr.getRightExpression().toString();
                columnName = ParserUtils.stripeQuotes(columnName);
                Column column = SimpleDmlParser.this.table.columnWithName(columnName);
                if (column == null) {
                    LOGGER.trace("excluded column in where clause: {}", (Object)columnName);
                    return;
                }
                value = ParserUtils.removeApostrophes(value);
                LogMinerColumnValueWrapper logMinerColumnValueWrapper = (LogMinerColumnValueWrapper)SimpleDmlParser.this.oldColumnValues.get(columnName.toUpperCase());
                if (logMinerColumnValueWrapper != null) {
                    Object valueObject = ParserUtils.convertValueToSchemaType(column, value, SimpleDmlParser.this.converter);
                    logMinerColumnValueWrapper.setProcessed(true);
                    logMinerColumnValueWrapper.getColumnValue().setColumnData(valueObject);
                }
            }

            public void visit(IsNullExpression expr) {
                super.visit(expr);
                String columnName = expr.getLeftExpression().toString();
                columnName = ParserUtils.stripeAlias(columnName, SimpleDmlParser.this.aliasName);
                columnName = ParserUtils.stripeQuotes(columnName);
                Column column = SimpleDmlParser.this.table.columnWithName(columnName);
                if (column == null) {
                    LOGGER.trace("excluded column in where clause: {}", (Object)columnName);
                    return;
                }
                LogMinerColumnValueWrapper logMinerColumnValueWrapper = (LogMinerColumnValueWrapper)SimpleDmlParser.this.oldColumnValues.get(columnName.toUpperCase());
                if (logMinerColumnValueWrapper != null) {
                    logMinerColumnValueWrapper.setProcessed(true);
                    logMinerColumnValueWrapper.getColumnValue().setColumnData(null);
                }
            }
        });
    }
}

