/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.oracle.Module;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleSourceInfoStructMaker;
import io.debezium.connector.oracle.logminer.HistoryRecorder;
import io.debezium.connector.oracle.logminer.NeverHistoryRecorder;
import io.debezium.connector.oracle.xstream.LcrPosition;
import io.debezium.connector.oracle.xstream.OracleVersion;
import io.debezium.document.Document;
import io.debezium.function.Predicates;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.relational.ColumnId;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.util.Strings;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.kafka.common.config.ConfigDef;

public class OracleConnectorConfig
extends HistorizedRelationalDatabaseConnectorConfig {
    protected static final int DEFAULT_PORT = 1528;
    protected static final int DEFAULT_VIEW_FETCH_SIZE = 10000;
    protected static final int DEFAULT_BATCH_SIZE = 20000;
    protected static final int MIN_BATCH_SIZE = 1000;
    protected static final int MAX_BATCH_SIZE = 100000;
    protected static final Duration MAX_SLEEP_TIME = Duration.ofMillis(3000L);
    protected static final Duration DEFAULT_SLEEP_TIME = Duration.ofMillis(1000L);
    protected static final Duration MIN_SLEEP_TIME = Duration.ZERO;
    protected static final Duration SLEEP_TIME_INCREMENT = Duration.ofMillis(200L);
    protected static final Duration DEFAULT_TRANSACTION_RETENTION = Duration.ofHours(4L);
    public static final Field PORT = RelationalDatabaseConnectorConfig.PORT.withDefault(1528);
    public static final Field HOSTNAME = RelationalDatabaseConnectorConfig.HOSTNAME.withNoValidation().withValidation(new Field.Validator[]{OracleConnectorConfig::requiredWhenNoUrl});
    public static final Field PDB_NAME = Field.create((String)"database.pdb.name").withDisplayName("PDB name").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withDescription("Name of the pluggable database when working with a multi-tenant set-up. The CDB name must be given via " + DATABASE_NAME.name() + " in this case.");
    public static final Field XSTREAM_SERVER_NAME = Field.create((String)"database.out.server.name").withDisplayName("XStream out server name").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{OracleConnectorConfig::validateOutServerName}).withDescription("Name of the XStream Out server to connect to.");
    public static final Field SNAPSHOT_MODE = Field.create((String)"snapshot.mode").withDisplayName("Snapshot mode").withEnum(SnapshotMode.class, (Enum)SnapshotMode.INITIAL).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("The criteria for running a snapshot upon startup of the connector. Options include: 'initial' (the default) to specify the connector should run a snapshot only when no offsets are available for the logical server name; 'schema_only' to specify the connector should run a snapshot of the schema when no offsets are available for the logical server name. ");
    public static final Field TABLENAME_CASE_INSENSITIVE = Field.create((String)"database.tablename.case.insensitive").withDisplayName("Case insensitive table names").withType(ConfigDef.Type.BOOLEAN).withDefault(false).withImportance(ConfigDef.Importance.LOW).withDescription("Case insensitive table names; set to 'true' for Oracle 11g, 'false' (default) otherwise.");
    public static final Field ORACLE_VERSION = Field.create((String)"database.oracle.version").withDisplayName("Oracle version, 11 or 12+").withEnum(OracleVersion.class, (Enum)OracleVersion.V12Plus).withImportance(ConfigDef.Importance.LOW).withDescription("For default Oracle 12+, use default pos_version value v2, for Oracle 11, use pos_version value v1.");
    public static final Field SERVER_NAME = RelationalDatabaseConnectorConfig.SERVER_NAME.withValidation(new Field.Validator[]{CommonConnectorConfig::validateServerNameIsDifferentFromHistoryTopicName});
    public static final Field CONNECTOR_ADAPTER = Field.create((String)"database.connection.adapter").withDisplayName("Connector adapter").withEnum(ConnectorAdapter.class, (Enum)ConnectorAdapter.XSTREAM).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withDescription("There are two adapters: XStream and LogMiner.");
    public static final Field LOG_MINING_STRATEGY = Field.create((String)"log.mining.strategy").withDisplayName("Log Mining Strategy").withEnum(LogMiningStrategy.class, (Enum)LogMiningStrategy.CATALOG_IN_REDO).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withDescription("There are strategies: Online catalog with faster mining but no captured DDL. Another - with data dictionary loaded into REDO LOG files");
    public static final Field CONTINUOUS_MINE = Field.create((String)"log.mining.continuous.mine").withDisplayName("Should log mining session configured with CONTINUOUS_MINE setting?").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(false).withValidation(new Field.Validator[]{Field::isBoolean}).withDescription("If true, CONTINUOUS_MINE option will be added to the log mining session. This will manage log files switches seamlessly.");
    public static final Field SNAPSHOT_ENHANCEMENT_TOKEN = Field.create((String)"snapshot.enhance.predicate.scn").withDisplayName("A string to replace on snapshot predicate enhancement").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withDescription("A token to replace on snapshot predicate template");
    public static final Field LOG_MINING_HISTORY_RECORDER_CLASS = Field.create((String)"log.mining.history.recorder.class").withDisplayName("Log Mining History Recorder Class").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withInvisibleRecommender().withDescription("Allows connector deployment to capture log mining results");
    public static final Field LOG_MINING_HISTORY_RETENTION = Field.create((String)"database.history.retention.hours").withDisplayName("Log Mining history retention").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(0).withDescription("Hours to keep Log Mining history.  By default, no history is retained.");
    public static final Field LOG_MINING_TRANSACTION_RETENTION = Field.create((String)"log.mining.transaction.retention.hours").withDisplayName("Log Mining long running transaction retention").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(DEFAULT_TRANSACTION_RETENTION.toHours()).withValidation(new Field.Validator[]{OracleConnectorConfig::isPositiveNonZeroInteger}).withDescription("Hours to keep long running transactions in transaction buffer between log mining sessions.");
    public static final Field RAC_SYSTEM = Field.create((String)"database.rac").withDisplayName("Oracle RAC").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDefault(false).withDescription("Flag to if it is RAC system");
    public static final Field RAC_NODES = Field.create((String)"rac.nodes").withDisplayName("Oracle RAC nodes").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("A comma-separated list of RAC node hostnames or ip addresses");
    public static final Field URL = Field.create((String)"database.url").withDisplayName("Complete JDBC URL").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{OracleConnectorConfig::requiredWhenNoHostname}).withDescription("Complete JDBC URL as an alternative to specifying hostname, port and database provided as a way to support alternative connection scenarios.");
    public static final Field LOG_MINING_DML_PARSER = Field.createInternal((String)"log.mining.dml.parser").withDisplayName("Log Mining DML parser implementation").withEnum(LogMiningDmlParser.class, (Enum)LogMiningDmlParser.FAST).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("The parser implementation to use when parsing DML operations:'legacy': the legacy parser implementation based on JSqlParser; 'fast': the robust parser implementation that is streamlined specifically for LogMiner redo format");
    public static final Field LOG_MINING_ARCHIVE_LOG_HOURS = Field.create((String)"log.mining.archive.log.hours").withDisplayName("Log Mining Archive Log Hours").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(0).withDescription("The number of hours in the past from SYSDATE to mine archive logs.  Using 0 mines all available archive logs");
    public static final Field LOG_MINING_BATCH_SIZE_MIN = Field.create((String)"log.mining.batch.size.min").withDisplayName("Minimum batch size for reading redo/archive logs.").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(1000).withDescription("The minimum SCN interval size that this connector will try to read from redo/archive logs. Active batch size will be also increased/decreased by this amount for tuning connector throughput when needed.");
    public static final Field LOG_MINING_BATCH_SIZE_DEFAULT = Field.create((String)"log.mining.batch.size.default").withDisplayName("Default batch size for reading redo/archive logs.").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(20000).withDescription("The starting SCN interval size that the connector will use for reading data from redo/archive logs.");
    public static final Field LOG_MINING_BATCH_SIZE_MAX = Field.create((String)"log.mining.batch.size.max").withDisplayName("Maximum batch size for reading redo/archive logs.").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(100000).withDescription("The maximum SCN interval size that this connector will use when reading from redo/archive logs.");
    public static final Field LOG_MINING_VIEW_FETCH_SIZE = Field.create((String)"log.mining.view.fetch.size").withDisplayName("Number of content records that will be fetched.").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(10000).withDescription("The number of content records that will be fetched from the LogMiner content view.");
    public static final Field LOG_MINING_SLEEP_TIME_MIN_MS = Field.create((String)"log.mining.sleep.time.min.ms").withDisplayName("Minimum sleep time in milliseconds when reading redo/archive logs.").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(MIN_SLEEP_TIME.toMillis()).withDescription("The minimum amount of time that the connector will sleep after reading data from redo/archive logs and before starting reading data again. Value is in milliseconds.");
    public static final Field LOG_MINING_SLEEP_TIME_DEFAULT_MS = Field.create((String)"log.mining.sleep.time.default.ms").withDisplayName("Default sleep time in milliseconds when reading redo/archive logs.").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(DEFAULT_SLEEP_TIME.toMillis()).withDescription("The amount of time that the connector will sleep after reading data from redo/archive logs and before starting reading data again. Value is in milliseconds.");
    public static final Field LOG_MINING_SLEEP_TIME_MAX_MS = Field.create((String)"log.mining.sleep.time.max.ms").withDisplayName("Maximum sleep time in milliseconds when reading redo/archive logs.").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(MAX_SLEEP_TIME.toMillis()).withDescription("The maximum amount of time that the connector will sleep after reading data from redo/archive logs and before starting reading data again. Value is in milliseconds.");
    public static final Field LOG_MINING_SLEEP_TIME_INCREMENT_MS = Field.create((String)"log.mining.sleep.time.increment.ms").withDisplayName("The increment in sleep time in milliseconds used to tune auto-sleep behavior.").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(SLEEP_TIME_INCREMENT.toMillis()).withDescription("The maximum amount of time that the connector will use to tune the optimal sleep time when reading data from LogMiner. Value is in milliseconds.");
    private static final ConfigDefinition CONFIG_DEFINITION = HistorizedRelationalDatabaseConnectorConfig.CONFIG_DEFINITION.edit().name("Oracle").excluding(new Field[]{SCHEMA_WHITELIST, SCHEMA_INCLUDE_LIST, SCHEMA_BLACKLIST, SCHEMA_EXCLUDE_LIST, RelationalDatabaseConnectorConfig.TABLE_IGNORE_BUILTIN, SERVER_NAME}).type(new Field[]{HOSTNAME, PORT, USER, PASSWORD, SERVER_NAME, DATABASE_NAME, PDB_NAME, XSTREAM_SERVER_NAME, SNAPSHOT_MODE, CONNECTOR_ADAPTER, LOG_MINING_STRATEGY, URL, TABLENAME_CASE_INSENSITIVE, ORACLE_VERSION}).connector(new Field[]{SNAPSHOT_ENHANCEMENT_TOKEN, RAC_SYSTEM, RAC_NODES, LOG_MINING_HISTORY_RECORDER_CLASS, LOG_MINING_HISTORY_RETENTION, LOG_MINING_ARCHIVE_LOG_HOURS, LOG_MINING_BATCH_SIZE_DEFAULT, LOG_MINING_BATCH_SIZE_MIN, LOG_MINING_BATCH_SIZE_MAX, LOG_MINING_SLEEP_TIME_DEFAULT_MS, LOG_MINING_SLEEP_TIME_MIN_MS, LOG_MINING_SLEEP_TIME_MAX_MS, LOG_MINING_SLEEP_TIME_INCREMENT_MS, LOG_MINING_TRANSACTION_RETENTION, LOG_MINING_DML_PARSER}).create();
    public static Field.Set ALL_FIELDS = Field.setOf((Iterable)CONFIG_DEFINITION.all());
    private final String databaseName;
    private final String pdbName;
    private final String xoutServerName;
    private final SnapshotMode snapshotMode;
    private final boolean tablenameCaseInsensitive;
    private final OracleVersion oracleVersion;
    private final HistoryRecorder logMiningHistoryRecorder;
    private final Configuration jdbcConfig;
    private final ConnectorAdapter connectorAdapter;
    private final String snapshotEnhancementToken;
    private final LogMiningStrategy logMiningStrategy;
    private final long logMiningHistoryRetentionHours;
    private final Set<String> racNodes;
    private final boolean logMiningContinuousMine;
    private final Duration logMiningArchiveLogRetention;
    private final int logMiningBatchSizeMin;
    private final int logMiningBatchSizeMax;
    private final int logMiningBatchSizeDefault;
    private final int logMiningViewFetchSize;
    private final Duration logMiningSleepTimeMin;
    private final Duration logMiningSleepTimeMax;
    private final Duration logMiningSleepTimeDefault;
    private final Duration logMiningSleepTimeIncrement;
    private final Duration logMiningTransactionRetention;
    private final LogMiningDmlParser dmlParser;

    public static ConfigDef configDef() {
        return CONFIG_DEFINITION.configDef();
    }

    public OracleConnectorConfig(Configuration config) {
        super(OracleConnector.class, config, config.getString(SERVER_NAME), (Tables.TableFilter)new SystemTablesPredicate(), x -> x.schema() + "." + x.table(), true);
        this.databaseName = OracleConnectorConfig.toUpperCase(config.getString(DATABASE_NAME));
        this.pdbName = OracleConnectorConfig.toUpperCase(config.getString(PDB_NAME));
        this.xoutServerName = config.getString(XSTREAM_SERVER_NAME);
        this.snapshotMode = SnapshotMode.parse(config.getString(SNAPSHOT_MODE));
        this.tablenameCaseInsensitive = config.getBoolean(TABLENAME_CASE_INSENSITIVE);
        this.oracleVersion = OracleVersion.parse(config.getString(ORACLE_VERSION));
        this.logMiningHistoryRecorder = OracleConnectorConfig.resolveLogMiningHistoryRecorder(config);
        this.jdbcConfig = config.subset("database.", true);
        this.snapshotEnhancementToken = config.getString(SNAPSHOT_ENHANCEMENT_TOKEN);
        this.connectorAdapter = ConnectorAdapter.parse(config.getString(CONNECTOR_ADAPTER));
        this.logMiningStrategy = LogMiningStrategy.parse(config.getString(LOG_MINING_STRATEGY));
        this.logMiningHistoryRetentionHours = config.getLong(LOG_MINING_HISTORY_RETENTION);
        this.racNodes = Strings.setOf((String)config.getString(RAC_NODES), String::new);
        this.logMiningContinuousMine = config.getBoolean(CONTINUOUS_MINE);
        this.logMiningArchiveLogRetention = Duration.ofHours(config.getLong(LOG_MINING_ARCHIVE_LOG_HOURS));
        this.logMiningBatchSizeMin = config.getInteger(LOG_MINING_BATCH_SIZE_MIN);
        this.logMiningBatchSizeMax = config.getInteger(LOG_MINING_BATCH_SIZE_MAX);
        this.logMiningBatchSizeDefault = config.getInteger(LOG_MINING_BATCH_SIZE_DEFAULT);
        this.logMiningViewFetchSize = config.getInteger(LOG_MINING_VIEW_FETCH_SIZE);
        this.logMiningSleepTimeMin = Duration.ofMillis(config.getInteger(LOG_MINING_SLEEP_TIME_MIN_MS));
        this.logMiningSleepTimeMax = Duration.ofMillis(config.getInteger(LOG_MINING_SLEEP_TIME_MAX_MS));
        this.logMiningSleepTimeDefault = Duration.ofMillis(config.getInteger(LOG_MINING_SLEEP_TIME_DEFAULT_MS));
        this.logMiningSleepTimeIncrement = Duration.ofMillis(config.getInteger(LOG_MINING_SLEEP_TIME_INCREMENT_MS));
        this.logMiningTransactionRetention = Duration.ofHours(config.getInteger(LOG_MINING_TRANSACTION_RETENTION));
        this.dmlParser = LogMiningDmlParser.parse(config.getString(LOG_MINING_DML_PARSER));
    }

    private static String toUpperCase(String property) {
        return property == null ? null : property.toUpperCase();
    }

    private static HistoryRecorder resolveLogMiningHistoryRecorder(Configuration config) {
        if (!config.hasKey(LOG_MINING_HISTORY_RECORDER_CLASS.name())) {
            return new NeverHistoryRecorder();
        }
        return (HistoryRecorder)config.getInstance(LOG_MINING_HISTORY_RECORDER_CLASS, HistoryRecorder.class);
    }

    protected Tables.ColumnNameFilter getColumnNameFilter(final String excludedColumnPatterns) {
        return new Tables.ColumnNameFilter(){
            Predicate<ColumnId> delegate;
            {
                this.delegate = Predicates.excludes((String)excludedColumnPatterns, ColumnId::toString);
            }

            public boolean matches(String catalogName, String schemaName, String tableName, String columnName) {
                return this.delegate.test(new ColumnId(new TableId(null, null, tableName), columnName));
            }
        };
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getPdbName() {
        return this.pdbName;
    }

    public String getCatalogName() {
        return this.pdbName != null ? this.pdbName : this.databaseName;
    }

    public String getXoutServerName() {
        return this.xoutServerName;
    }

    public SnapshotMode getSnapshotMode() {
        return this.snapshotMode;
    }

    public boolean getTablenameCaseInsensitive() {
        return this.tablenameCaseInsensitive;
    }

    public OracleVersion getOracleVersion() {
        return this.oracleVersion;
    }

    protected HistoryRecordComparator getHistoryRecordComparator() {
        return new HistoryRecordComparator(){

            protected boolean isPositionAtOrBefore(Document recorded, Document desired) {
                Long desiredScn;
                if (OracleConnectorConfig.this.getAdapter() == ConnectorAdapter.XSTREAM) {
                    LcrPosition recordedPosition = LcrPosition.valueOf(recorded.getString((CharSequence)"lcr_position"));
                    LcrPosition desiredPosition = LcrPosition.valueOf(desired.getString((CharSequence)"lcr_position"));
                    Long recordedScn = recordedPosition != null ? recordedPosition.getScn() : recorded.getLong((CharSequence)"scn").longValue();
                    Long desiredScn2 = desiredPosition != null ? desiredPosition.getScn() : desired.getLong((CharSequence)"scn").longValue();
                    return recordedPosition != null && desiredPosition != null ? recordedPosition.compareTo(desiredPosition) < 1 : recordedScn.compareTo(desiredScn2) < 1;
                }
                Long recordedScn = recorded.getLong((CharSequence)"scn");
                return recordedScn.compareTo(desiredScn = desired.getLong((CharSequence)"scn")) < 1;
            }
        };
    }

    protected SourceInfoStructMaker<? extends AbstractSourceInfo> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
        return new OracleSourceInfoStructMaker(Module.name(), Module.version(), (CommonConnectorConfig)this);
    }

    public String getContextName() {
        return Module.contextName();
    }

    public ConnectorAdapter getAdapter() {
        return this.connectorAdapter;
    }

    public LogMiningStrategy getLogMiningStrategy() {
        return this.logMiningStrategy;
    }

    public Boolean isLogMiningHistoryRecorded() {
        return this.logMiningHistoryRetentionHours > 0L;
    }

    public HistoryRecorder getLogMiningHistoryRecorder() {
        return this.logMiningHistoryRecorder;
    }

    public long getLogMinerHistoryRetentionHours() {
        return this.logMiningHistoryRetentionHours;
    }

    public Boolean isRacSystem() {
        return !this.racNodes.isEmpty();
    }

    public Set<String> getRacNodes() {
        return this.racNodes;
    }

    public String getTokenToReplaceInSnapshotPredicate() {
        return this.snapshotEnhancementToken;
    }

    public boolean isContinuousMining() {
        return this.logMiningContinuousMine;
    }

    public Duration getLogMiningArchiveLogRetention() {
        return this.logMiningArchiveLogRetention;
    }

    public int getLogMiningBatchSizeMin() {
        return this.logMiningBatchSizeMin;
    }

    public int getLogMiningViewFetchSize() {
        return this.logMiningViewFetchSize;
    }

    public int getLogMiningBatchSizeMax() {
        return this.logMiningBatchSizeMax;
    }

    public int getLogMiningBatchSizeDefault() {
        return this.logMiningBatchSizeDefault;
    }

    public Duration getLogMiningSleepTimeMin() {
        return this.logMiningSleepTimeMin;
    }

    public Duration getLogMiningSleepTimeMax() {
        return this.logMiningSleepTimeMax;
    }

    public Duration getLogMiningSleepTimeDefault() {
        return this.logMiningSleepTimeDefault;
    }

    public Duration getLogMiningSleepTimeIncrement() {
        return this.logMiningSleepTimeIncrement;
    }

    public Duration getLogMiningTransactionRetention() {
        return this.logMiningTransactionRetention;
    }

    public LogMiningDmlParser getLogMiningDmlParser() {
        return this.dmlParser;
    }

    public Configuration jdbcConfig() {
        return this.jdbcConfig;
    }

    public String getConnectorName() {
        return Module.name();
    }

    public static List<String> getExcludedSchemaNames() {
        return Arrays.asList("appqossys", "audsys", "ctxsys", "dvsys", "dbsfwuser", "dbsnmp", "gsmadmin_internal", "lbacsys", "mdsys", "ojvmsys", "olapsys", "orddata", "ordsys", "outln", "sys", "system", "wmsys", "xdb");
    }

    public static int validateOutServerName(Configuration config, Field field, Field.ValidationOutput problems) {
        if (ConnectorAdapter.XSTREAM.equals((Object)ConnectorAdapter.parse(config.getString(CONNECTOR_ADAPTER)))) {
            return Field.isRequired((Configuration)config, (Field)field, (Field.ValidationOutput)problems);
        }
        return 0;
    }

    public static int requiredWhenNoUrl(Configuration config, Field field, Field.ValidationOutput problems) {
        if (config.getString(URL) == null) {
            return Field.isRequired((Configuration)config, (Field)field, (Field.ValidationOutput)problems);
        }
        return 0;
    }

    public static int requiredWhenNoHostname(Configuration config, Field field, Field.ValidationOutput problems) {
        if (config.getString(HOSTNAME) == null) {
            return Field.isRequired((Configuration)config, (Field)field, (Field.ValidationOutput)problems);
        }
        return 0;
    }

    public static int isPositiveNonZeroInteger(Configuration config, Field field, Field.ValidationOutput problems) {
        Integer value = config.getInteger(field);
        if (value == 0) {
            problems.accept(field, (Object)value, "The value must be non-zero.");
            return 1;
        }
        return Field.isPositiveInteger((Configuration)config, (Field)field, (Field.ValidationOutput)problems);
    }

    private static class SystemTablesPredicate
    implements Tables.TableFilter {
        private SystemTablesPredicate() {
        }

        public boolean isIncluded(TableId t) {
            return !OracleConnectorConfig.getExcludedSchemaNames().contains(t.schema().toLowerCase());
        }
    }

    public static enum LogMiningDmlParser implements EnumeratedValue
    {
        LEGACY("legacy"),
        FAST("fast");

        private final String value;

        private LogMiningDmlParser(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static LogMiningDmlParser parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (LogMiningDmlParser parser : LogMiningDmlParser.values()) {
                if (!parser.getValue().equalsIgnoreCase(value)) continue;
                return parser;
            }
            return null;
        }

        public static LogMiningDmlParser parse(String value, String defaultValue) {
            LogMiningDmlParser mode = LogMiningDmlParser.parse(value);
            if (mode == null && defaultValue != null) {
                mode = LogMiningDmlParser.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum LogMiningStrategy implements EnumeratedValue
    {
        ONLINE_CATALOG("online_catalog"),
        CATALOG_IN_REDO("redo_log_catalog");

        private final String value;

        private LogMiningStrategy(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static LogMiningStrategy parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (LogMiningStrategy adapter : LogMiningStrategy.values()) {
                if (!adapter.getValue().equalsIgnoreCase(value)) continue;
                return adapter;
            }
            return null;
        }

        public static LogMiningStrategy parse(String value, String defaultValue) {
            LogMiningStrategy mode = LogMiningStrategy.parse(value);
            if (mode == null && defaultValue != null) {
                mode = LogMiningStrategy.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum ConnectorAdapter implements EnumeratedValue
    {
        XSTREAM("XStream"){

            @Override
            public String getConnectionUrl() {
                return "jdbc:oracle:oci:@${" + JdbcConfiguration.HOSTNAME + "}:${" + JdbcConfiguration.PORT + "}/${" + JdbcConfiguration.DATABASE + "}";
            }
        }
        ,
        LOG_MINER("LogMiner"){

            @Override
            public String getConnectionUrl() {
                return "jdbc:oracle:thin:@${" + JdbcConfiguration.HOSTNAME + "}:${" + JdbcConfiguration.PORT + "}/${" + JdbcConfiguration.DATABASE + "}";
            }
        };

        private final String value;

        public abstract String getConnectionUrl();

        private ConnectorAdapter(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static ConnectorAdapter parse(String value) {
            if (value == null) {
                return XSTREAM;
            }
            value = value.trim();
            for (ConnectorAdapter adapter : ConnectorAdapter.values()) {
                if (!adapter.getValue().equalsIgnoreCase(value)) continue;
                return adapter;
            }
            return null;
        }

        public static ConnectorAdapter parse(String value, String defaultValue) {
            ConnectorAdapter mode = ConnectorAdapter.parse(value);
            if (mode == null && defaultValue != null) {
                mode = ConnectorAdapter.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum SnapshotMode implements EnumeratedValue
    {
        INITIAL("initial", true),
        SCHEMA_ONLY("schema_only", false);

        private final String value;
        private final boolean includeData;

        private SnapshotMode(String value, boolean includeData) {
            this.value = value;
            this.includeData = includeData;
        }

        public String getValue() {
            return this.value;
        }

        public boolean includeData() {
            return this.includeData;
        }

        public static SnapshotMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotMode option : SnapshotMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotMode parse(String value, String defaultValue) {
            SnapshotMode mode = SnapshotMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotMode.parse(defaultValue);
            }
            return mode;
        }
    }
}

