/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlPartition;
import io.debezium.data.Envelope;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.RelationalChangeRecordEmitter;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableSchema;
import io.debezium.schema.DataCollectionSchema;
import io.debezium.util.Clock;
import java.io.Serializable;
import org.apache.kafka.connect.data.Struct;

public class MySqlChangeRecordEmitter
extends RelationalChangeRecordEmitter<MySqlPartition> {
    private final Envelope.Operation operation;
    private final OffsetContext offset;
    private final Object[] before;
    private final Object[] after;

    public MySqlChangeRecordEmitter(MySqlPartition partition, OffsetContext offset, Clock clock, Envelope.Operation operation, Serializable[] before, Serializable[] after, MySqlConnectorConfig connectorConfig) {
        super((Partition)partition, offset, clock, (RelationalDatabaseConnectorConfig)connectorConfig);
        this.offset = offset;
        this.operation = operation;
        this.before = before;
        this.after = after;
    }

    public OffsetContext getOffset() {
        return this.offset;
    }

    public Envelope.Operation getOperation() {
        return this.operation;
    }

    protected Object[] getOldColumnValues() {
        return this.before;
    }

    protected Object[] getNewColumnValues() {
        return this.after;
    }

    protected void emitTruncateRecord(ChangeRecordEmitter.Receiver receiver, TableSchema tableSchema) throws InterruptedException {
        Struct envelope = tableSchema.getEnvelopeSchema().truncate(this.getOffset().getSourceInfo(), this.getClock().currentTimeAsInstant());
        receiver.changeRecord(this.getPartition(), (DataCollectionSchema)tableSchema, Envelope.Operation.TRUNCATE, null, envelope, this.getOffset(), null);
    }
}

