/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cockroachdb.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangefeedSchemaParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangefeedSchemaParser.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Schema ENRICHED_ENVELOPE_SCHEMA = SchemaBuilder.struct().name("io.debezium.connector.cockroachdb.EnrichedEnvelope").field("key", Schema.OPTIONAL_STRING_SCHEMA).field("value", Schema.OPTIONAL_STRING_SCHEMA).field("updated", Schema.OPTIONAL_STRING_SCHEMA).field("diff", Schema.OPTIONAL_STRING_SCHEMA).field("resolved", Schema.OPTIONAL_STRING_SCHEMA).build();

    public static ParsedChange parse(String keyJson, String valueJson) throws Exception {
        if ((keyJson == null || keyJson.isBlank()) && (valueJson == null || valueJson.isBlank())) {
            LOGGER.debug("Processing resolved timestamp or empty message");
            return new ParsedChange(null, null, null, null);
        }
        try {
            JsonNode resolvedNode;
            JsonNode keyNode;
            JsonNode valueNode = valueJson == null || valueJson.isBlank() ? null : OBJECT_MAPPER.readTree(valueJson);
            JsonNode jsonNode = keyNode = keyJson == null || keyJson.isBlank() ? null : OBJECT_MAPPER.readTree(keyJson);
            if (valueNode != null && valueNode.isObject() && valueNode.size() == 0) {
                Schema emptySchema = ChangefeedSchemaParser.createEnvelopeSchema(valueNode);
                Schema keySchema = keyNode != null && keyNode.isObject() && keyNode.size() == 0 ? SchemaBuilder.struct().name("io.debezium.connector.cockroachdb.EmptyKey").build() : ChangefeedSchemaParser.createSchemaFromJson(keyNode);
                Object key = keyNode != null ? ChangefeedSchemaParser.convertJsonToStruct(keyNode, keySchema) : null;
                Struct value = new Struct(emptySchema);
                return new ParsedChange(keySchema, key, emptySchema, value);
            }
            JsonNode jsonNode2 = resolvedNode = valueNode != null ? valueNode.get("resolved") : null;
            if (resolvedNode != null && valueNode.size() == 1) {
                Schema valueSchema = SchemaBuilder.struct().name("io.debezium.connector.cockroachdb.ResolvedEnvelope").field("resolved", Schema.STRING_SCHEMA).build();
                Struct valueStruct = new Struct(valueSchema).put("resolved", (Object)resolvedNode.asText());
                return new ParsedChange(null, null, valueSchema, valueStruct);
            }
            Schema keySchema = ChangefeedSchemaParser.createSchemaFromJson(keyNode);
            Object key = keyNode != null ? ChangefeedSchemaParser.convertJsonToStruct(keyNode, keySchema) : null;
            Schema valueSchema = ChangefeedSchemaParser.createEnvelopeSchema(valueNode);
            Struct value = new Struct(valueSchema);
            if (valueNode != null) {
                if (valueNode.has("after")) {
                    value.put("after", ChangefeedSchemaParser.convertJsonToStruct(valueNode.get("after"), valueSchema.field("after").schema()));
                }
                if (valueNode.has("before")) {
                    value.put("before", ChangefeedSchemaParser.convertJsonToStruct(valueNode.get("before"), valueSchema.field("before").schema()));
                }
                if (valueNode.has("updated")) {
                    value.put("updated", ChangefeedSchemaParser.convertJsonToStruct(valueNode.get("updated"), valueSchema.field("updated").schema()));
                }
                if (valueNode.has("diff")) {
                    value.put("diff", ChangefeedSchemaParser.convertJsonToStruct(valueNode.get("diff"), valueSchema.field("diff").schema()));
                }
                if (valueNode.has("resolved")) {
                    value.put("resolved", (Object)valueNode.get("resolved").asText());
                }
                if (valueNode.has("op")) {
                    value.put("op", (Object)valueNode.get("op").asText());
                }
                if (valueNode.has("source")) {
                    value.put("source", ChangefeedSchemaParser.convertJsonToStruct(valueNode.get("source"), valueSchema.field("source").schema()));
                }
                if (valueNode.has("ts_ns")) {
                    value.put("ts_ns", (Object)valueNode.get("ts_ns").asLong());
                }
            }
            return new ParsedChange(keySchema, key, valueSchema, value);
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse changefeed message: key={}, value={}", new Object[]{keyJson, valueJson, e});
            throw e;
        }
    }

    private static Schema createSchemaFromJson(JsonNode node) {
        if (node == null || node.isNull()) {
            return Schema.OPTIONAL_STRING_SCHEMA;
        }
        if (node.isObject()) {
            SchemaBuilder builder = SchemaBuilder.struct();
            node.fieldNames().forEachRemaining(fieldName -> {
                JsonNode fieldNode = node.get(fieldName);
                builder.field(fieldName, ChangefeedSchemaParser.createSchemaFromJson(fieldNode));
            });
            return builder.build();
        }
        if (node.isArray()) {
            return Schema.OPTIONAL_STRING_SCHEMA;
        }
        if (node.isTextual()) {
            return Schema.STRING_SCHEMA;
        }
        if (node.isNumber()) {
            if (node.isInt()) {
                return Schema.INT32_SCHEMA;
            }
            if (node.isLong()) {
                return Schema.INT64_SCHEMA;
            }
            return Schema.FLOAT64_SCHEMA;
        }
        if (node.isBoolean()) {
            return Schema.BOOLEAN_SCHEMA;
        }
        return Schema.STRING_SCHEMA;
    }

    private static Schema createEnrichedValueSchema(JsonNode valueNode, JsonNode updatedNode, JsonNode diffNode) {
        SchemaBuilder builder = SchemaBuilder.struct().name("io.debezium.connector.cockroachdb.EnrichedValue");
        if (valueNode != null) {
            Schema valueSchema = ChangefeedSchemaParser.createSchemaFromJson(valueNode);
            builder.field("value", valueSchema);
        }
        if (updatedNode != null) {
            builder.field("updated", Schema.OPTIONAL_STRING_SCHEMA);
        }
        if (diffNode != null) {
            builder.field("diff", Schema.OPTIONAL_STRING_SCHEMA);
        }
        return builder.build();
    }

    private static Object convertJsonToStruct(JsonNode node, Schema schema) {
        if (node == null || node.isNull()) {
            return null;
        }
        if (schema.type() == Schema.Type.STRUCT) {
            Struct struct = new Struct(schema);
            node.fieldNames().forEachRemaining(fieldName -> {
                if (schema.field(fieldName) != null) {
                    JsonNode fieldNode = node.get(fieldName);
                    Schema fieldSchema = schema.field(fieldName).schema();
                    struct.put(fieldName, ChangefeedSchemaParser.convertJsonToStruct(fieldNode, fieldSchema));
                }
            });
            return struct;
        }
        if (schema.type() == Schema.Type.ARRAY) {
            return node.toString();
        }
        if (node.isTextual()) {
            return node.asText();
        }
        if (node.isInt()) {
            return node.asInt();
        }
        if (node.isLong()) {
            return node.asLong();
        }
        if (node.isDouble()) {
            return node.asDouble();
        }
        if (node.isBoolean()) {
            return node.asBoolean();
        }
        if (node.isArray()) {
            return node.toString();
        }
        return node.toString();
    }

    private static Schema createEnvelopeSchema(JsonNode node) {
        SchemaBuilder builder = SchemaBuilder.struct().name("io.debezium.connector.cockroachdb.Envelope");
        builder.field("after", node != null && node.has("after") ? ChangefeedSchemaParser.createSchemaFromJson(node.get("after")) : SchemaBuilder.struct().optional().build());
        builder.field("before", node != null && node.has("before") ? ChangefeedSchemaParser.createSchemaFromJson(node.get("before")) : SchemaBuilder.struct().optional().build());
        builder.field("updated", node != null && node.has("updated") ? ChangefeedSchemaParser.createSchemaFromJson(node.get("updated")) : SchemaBuilder.struct().optional().build());
        builder.field("diff", node != null && node.has("diff") ? ChangefeedSchemaParser.createSchemaFromJson(node.get("diff")) : SchemaBuilder.struct().optional().build());
        builder.field("resolved", Schema.OPTIONAL_STRING_SCHEMA);
        builder.field("op", Schema.OPTIONAL_STRING_SCHEMA);
        builder.field("source", node != null && node.has("source") ? ChangefeedSchemaParser.createSchemaFromJson(node.get("source")) : SchemaBuilder.struct().optional().build());
        builder.field("ts_ns", Schema.OPTIONAL_INT64_SCHEMA);
        return builder.build();
    }

    public record ParsedChange(Schema keySchema, Object key, Schema valueSchema, Object value) {
    }
}

