/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cockroachdb;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.cockroachdb.CockroachDBConnectorConfig;
import io.debezium.connector.common.BaseSourceInfo;
import java.time.Instant;

@NotThreadSafe
public class SourceInfo
extends BaseSourceInfo {
    public static final String SNAPSHOT_KEY = "snapshot";
    public static final String DATABASE_NAME_KEY = "db";
    private final String databaseName;
    private final String clusterName;
    private Instant sourceTime = Instant.EPOCH;
    private String resolvedTimestamp;
    private String hlc;
    private Long tsNanos;

    protected SourceInfo(CockroachDBConnectorConfig connectorConfig) {
        super((CommonConnectorConfig)connectorConfig);
        this.databaseName = connectorConfig.getDatabaseName();
        this.clusterName = connectorConfig.getLogicalName();
    }

    public void setSourceTime(Instant instant) {
        this.sourceTime = instant != null ? instant : Instant.EPOCH;
    }

    protected Instant timestamp() {
        return this.sourceTime;
    }

    protected String database() {
        return this.databaseName;
    }

    public String cluster() {
        return this.clusterName;
    }

    public void setResolvedTimestamp(String resolvedTimestamp) {
        this.resolvedTimestamp = resolvedTimestamp;
    }

    public String resolvedTimestamp() {
        return this.resolvedTimestamp;
    }

    public void setHlc(String hlc) {
        this.hlc = hlc;
    }

    public String hlc() {
        return this.hlc;
    }

    public void setTsNanos(Long tsNanos) {
        this.tsNanos = tsNanos;
    }

    public Long tsNanos() {
        return this.tsNanos;
    }
}

